/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.util.StringUtils;

public final class WhitelistLogoutHandler
extends SimpleUrlLogoutSuccessHandler {
    private static final Log logger = LogFactory.getLog(WhitelistLogoutHandler.class);
    private List<String> whitelist = null;
    private ClientDetailsService clientDetailsService;

    public WhitelistLogoutHandler(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    protected boolean isAlwaysUseDefaultTargetUrl() {
        return false;
    }

    public void setWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    private Set<String> getClientWhitelist(HttpServletRequest request) {
        String clientId = request.getParameter("client_id");
        Set redirectUris = null;
        if (StringUtils.hasText((String)clientId)) {
            try {
                ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
                redirectUris = client.getRegisteredRedirectUri();
            }
            catch (NoSuchClientException x) {
                logger.debug((Object)String.format("Unable to find client with ID:%s for logout redirect", clientId));
            }
        }
        return redirectUris;
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String targetUrl = super.determineTargetUrl(request, response);
        if (this.isInternalRedirect(targetUrl, request)) {
            return targetUrl;
        }
        if (super.isAlwaysUseDefaultTargetUrl()) {
            return this.getDefaultTargetUrl();
        }
        String defaultTargetUrl = this.getDefaultTargetUrl();
        if (targetUrl.equals(defaultTargetUrl)) {
            return targetUrl;
        }
        Set<String> clientWhitelist = this.getClientWhitelist(request);
        Set<String> combinedWhitelist = WhitelistLogoutHandler.combineSets(this.whitelist, clientWhitelist);
        String whiteListRedirect = UaaUrlUtils.findMatchingRedirectUri(combinedWhitelist, targetUrl, defaultTargetUrl);
        return whiteListRedirect;
    }

    private boolean isInternalRedirect(String targetUrl, HttpServletRequest request) {
        String serverUrl = request.getRequestURL().toString().replaceAll("/logout\\.do$", "/");
        return targetUrl.startsWith(serverUrl);
    }

    private static <T> Set<T> combineSets(Collection<T> ... sets) {
        HashSet<T> combined = null;
        for (Collection<T> set : sets) {
            if (set == null) continue;
            if (combined == null) {
                combined = new HashSet<T>(set);
                continue;
            }
            combined.addAll(set);
        }
        return combined;
    }
}

