/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.security.Principal;
import java.util.Collections;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ClientInfoEndpoint
implements InitializingBean {
    private ClientDetailsService clientDetailsService;

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.clientDetailsService, (String)"clientDetailsService must be set");
    }

    @RequestMapping(value={"/clientinfo"})
    @ResponseBody
    public ClientDetails clientinfo(Principal principal) {
        String clientId = principal.getName();
        BaseClientDetails client = new BaseClientDetails(this.clientDetailsService.loadClientByClientId(clientId));
        client.setClientSecret(null);
        client.setAdditionalInformation(Collections.emptyMap());
        return client;
    }
}

