/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client.event;

import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.client.event.AbstractClientAdminEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.ClientDetails;

public class SecretFailureEvent
extends AbstractClientAdminEvent {
    private String message;

    public SecretFailureEvent(String message, Authentication principal) {
        this(message, null, principal);
    }

    public SecretFailureEvent(String message, ClientDetails client, Authentication principal) {
        super(client, principal);
        this.message = message;
    }

    @Override
    public AuditEvent getAuditEvent() {
        ClientDetails client = this.getClient();
        if (client == null) {
            return this.createAuditRecord(this.getPrincipal().getName(), AuditEventType.SecretChangeFailure, this.getOrigin(this.getPrincipal()), this.message);
        }
        return this.createAuditRecord(client.getClientId(), AuditEventType.SecretChangeFailure, this.getOrigin(this.getPrincipal()), this.message);
    }
}

