/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.login.CurrentUserInformation;
import org.cloudfoundry.identity.uaa.login.SavedAccountOption;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class AccountSavingAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Autowired
    public SavedRequestAwareAuthenticationSuccessHandler redirectingHandler;

    public SavedRequestAwareAuthenticationSuccessHandler getRedirectingHandler() {
        return this.redirectingHandler;
    }

    public void setRedirectingHandler(SavedRequestAwareAuthenticationSuccessHandler redirectingHandler) {
        this.redirectingHandler = redirectingHandler;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.setSavedAccountOptionCookie(request, response, authentication);
        this.redirectingHandler.onAuthenticationSuccess(request, response, authentication);
    }

    public void setSavedAccountOptionCookie(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IllegalArgumentException {
        Cookie currentUserCookie;
        Object principal = authentication.getPrincipal();
        if (!(principal instanceof UaaPrincipal)) {
            throw new IllegalArgumentException("Unrecognized authentication principle.");
        }
        UaaPrincipal uaaPrincipal = (UaaPrincipal)principal;
        SavedAccountOption savedAccountOption = new SavedAccountOption();
        savedAccountOption.setEmail(uaaPrincipal.getEmail());
        savedAccountOption.setOrigin(uaaPrincipal.getOrigin());
        savedAccountOption.setUserId(uaaPrincipal.getId());
        savedAccountOption.setUsername(uaaPrincipal.getName());
        Cookie savedAccountCookie = new Cookie("Saved-Account-" + uaaPrincipal.getId(), JsonUtils.writeValueAsString((Object)savedAccountOption));
        savedAccountCookie.setPath(request.getContextPath() + "/login");
        savedAccountCookie.setHttpOnly(true);
        savedAccountCookie.setSecure(request.isSecure());
        savedAccountCookie.setMaxAge(31536000);
        response.addCookie(savedAccountCookie);
        CurrentUserInformation currentUserInformation = new CurrentUserInformation();
        currentUserInformation.setUserId(uaaPrincipal.getId());
        try {
            currentUserCookie = new Cookie("Current-User", URLEncoder.encode(JsonUtils.writeValueAsString((Object)currentUserInformation), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        currentUserCookie.setMaxAge(31536000);
        currentUserCookie.setHttpOnly(false);
        currentUserCookie.setPath(request.getContextPath());
        response.addCookie(currentUserCookie);
    }
}

