/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.idp.ZoneAwareIdpMetadataManager;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.cloudfoundry.identity.uaa.zone.event.ServiceProviderModifiedEvent;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.context.ApplicationListener;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;

public class SamlServiceProviderChangedListener
implements ApplicationListener<ServiceProviderModifiedEvent> {
    private static final Log logger = LogFactory.getLog(SamlServiceProviderChangedListener.class);
    private ZoneAwareIdpMetadataManager metadataManager = null;
    private final SamlServiceProviderConfigurator configurator;
    private final IdentityZoneProvisioning zoneProvisioning;

    public SamlServiceProviderChangedListener(SamlServiceProviderConfigurator configurator, IdentityZoneProvisioning zoneProvisioning) {
        this.configurator = configurator;
        this.zoneProvisioning = zoneProvisioning;
    }

    public void onApplicationEvent(ServiceProviderModifiedEvent event) {
        if (this.metadataManager == null) {
            return;
        }
        SamlServiceProvider changedSamlServiceProvider = (SamlServiceProvider)event.getSource();
        IdentityZone zone = this.zoneProvisioning.retrieve(changedSamlServiceProvider.getIdentityZoneId());
        ZoneAwareIdpMetadataManager.ExtensionMetadataManager manager = this.metadataManager.getManager(zone);
        try {
            if (changedSamlServiceProvider.isActive()) {
                ExtendedMetadataDelegate[] delegates = this.configurator.addSamlServiceProvider(changedSamlServiceProvider);
                if (delegates[1] != null) {
                    manager.removeMetadataProvider((MetadataProvider)delegates[1]);
                }
                manager.addMetadataProvider((MetadataProvider)delegates[0]);
            } else {
                ExtendedMetadataDelegate delegate = this.configurator.removeSamlServiceProvider(changedSamlServiceProvider.getEntityId());
                if (delegate != null) {
                    manager.removeMetadataProvider((MetadataProvider)delegate);
                }
            }
            for (MetadataProvider provider : manager.getProviders()) {
                provider.getMetadata();
            }
            manager.refreshMetadata();
            this.metadataManager.getManager(zone).refreshMetadata();
        }
        catch (MetadataProviderException e) {
            logger.error((Object)("Unable to add new SAML service provider: " + changedSamlServiceProvider), (Throwable)e);
        }
    }

    public void setMetadataManager(ZoneAwareIdpMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }
}

