/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.resources;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.resources.AttributeNameMapper;
import org.cloudfoundry.identity.uaa.resources.SearchResults;
import org.cloudfoundry.identity.uaa.resources.SimpleAttributeNameMapper;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.MapCollector;
import org.springframework.util.Assert;

public class SearchResultsFactory {
    public static <T> SearchResults<Map<String, Object>> cropAndBuildSearchResultFrom(List<T> input, int startIndex, int count, int total, String[] attributes, List<String> schemas) {
        if (startIndex <= 0) {
            startIndex = 1;
        }
        if (startIndex - 1 >= input.size()) {
            count = 0;
        }
        if (startIndex - 1 + count >= input.size()) {
            count = input.size() - (startIndex - 1);
        }
        input = count > 0 ? input.subList(startIndex - 1, startIndex - 1 + count) : Collections.emptyList();
        return SearchResultsFactory.buildSearchResultFrom(input, startIndex, count, total, attributes, new SimpleAttributeNameMapper(Collections.emptyMap()), schemas);
    }

    public static <T> SearchResults<Map<String, Object>> buildSearchResultFrom(List<T> input, int startIndex, int count, int total, String[] attributes, List<String> schemas) {
        return SearchResultsFactory.buildSearchResultFrom(input, startIndex, count, total, attributes, new SimpleAttributeNameMapper(Collections.emptyMap()), schemas);
    }

    public static <T> SearchResults<Map<String, Object>> buildSearchResultFrom(List<T> input, int startIndex, int count, int total, String[] attributes, AttributeNameMapper mapper, List<String> schemas) {
        Assert.state((input.size() <= count ? 1 : 0) != 0, (String)"Cannot build search results from parent list. Use subList before you call this method.");
        Map jsonPaths = (Map)Arrays.asList(attributes).stream().collect(new MapCollector<String, String, JsonPath>(attribute -> attribute, attribute -> {
            String jsonPath = "$." + mapper.mapToInternal((String)attribute);
            return JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        }));
        ArrayList results = new ArrayList();
        for (T object : input) {
            LinkedHashMap map = new LinkedHashMap();
            String serializedObject = JsonUtils.writeValueAsString(object);
            for (Map.Entry attribute2 : jsonPaths.entrySet()) {
                try {
                    Object value = ((JsonPath)attribute2.getValue()).read(serializedObject);
                    map.put(attribute2.getKey(), value);
                }
                catch (PathNotFoundException e) {
                    map.put(attribute2.getKey(), null);
                }
            }
            results.add(map);
        }
        return new SearchResults(schemas, results, startIndex, count, total);
    }
}

