/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.security.GeneralSecurityException;
import java.util.Map;
import org.cloudfoundry.identity.uaa.util.KeyWithCert;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfigurationValidator;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneConfigurationException;
import org.cloudfoundry.identity.uaa.zone.SamlConfig;
import org.cloudfoundry.identity.uaa.zone.TokenPolicy;
import org.springframework.util.StringUtils;

public class GeneralIdentityZoneConfigurationValidator
implements IdentityZoneConfigurationValidator {
    @Override
    public IdentityZoneConfiguration validate(IdentityZoneConfiguration config, IdentityZoneConfigurationValidator.Mode mode) throws InvalidIdentityZoneConfigurationException {
        if (mode == IdentityZoneConfigurationValidator.Mode.CREATE || mode == IdentityZoneConfigurationValidator.Mode.MODIFY) {
            String activeKeyId;
            try {
                SamlConfig samlConfig = config.getSamlConfig();
                if (samlConfig != null) {
                    String samlSpCert = samlConfig.getCertificate();
                    String samlSpKey = samlConfig.getPrivateKey();
                    String samlSpkeyPassphrase = samlConfig.getPrivateKeyPassword();
                    if (samlSpKey != null && samlSpCert != null) {
                        KeyWithCert keyWithCert = new KeyWithCert(samlSpKey, samlSpkeyPassphrase, samlSpCert);
                    }
                    this.failIfPartialCertKeyInfo(samlSpCert, samlSpKey, samlSpkeyPassphrase);
                }
            }
            catch (GeneralSecurityException ex) {
                throw new InvalidIdentityZoneConfigurationException("There is a security problem with the SAML SP configuration.", ex);
            }
            TokenPolicy tokenPolicy = config.getTokenPolicy();
            if (tokenPolicy != null && StringUtils.hasText((String)(activeKeyId = tokenPolicy.getActiveKeyId()))) {
                Map jwtKeys = tokenPolicy.getKeys();
                if (jwtKeys == null || jwtKeys.isEmpty()) {
                    throw new InvalidIdentityZoneConfigurationException("Identity zone cannot specify an active key ID with no keys configured for the zone.", null);
                }
                if (!jwtKeys.containsKey(activeKeyId)) {
                    throw new InvalidIdentityZoneConfigurationException("The specified active key ID is not present in the configured keys: " + activeKeyId, null);
                }
            }
        }
        return config;
    }

    private void failIfPartialCertKeyInfo(String samlSpCert, String samlSpKey, String samlSpkeyPassphrase) throws InvalidIdentityZoneConfigurationException {
        if (samlSpCert == null && samlSpKey == null && samlSpkeyPassphrase == null || samlSpCert != null && samlSpKey != null && samlSpkeyPassphrase != null) {
            return;
        }
        throw new InvalidIdentityZoneConfigurationException("Identity zone cannot be udpated with partial Saml CertKey config.", null);
    }
}

