/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.invitations;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.account.PasswordConfirmationValidation;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.authentication.manager.DynamicZoneAwareAuthenticationManager;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.invitations.InvitationsService;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.ldap.ExtendedLdapUserDetails;
import org.cloudfoundry.identity.uaa.provider.saml.SamlRedirectUtils;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.validate.PasswordValidator;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.ldap.AuthenticationException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.RequestContextHolder;

@Controller
@RequestMapping(value={"/invitations"})
public class InvitationsController {
    private static Log logger = LogFactory.getLog(InvitationsController.class);
    private final InvitationsService invitationsService;
    private PasswordValidator passwordValidator;
    private ExpiringCodeStore expiringCodeStore;
    private IdentityProviderProvisioning providerProvisioning;
    private UaaUserDatabase userDatabase;
    private DynamicZoneAwareAuthenticationManager zoneAwareAuthenticationManager;
    private ScimUserProvisioning userProvisioning;
    private String spEntityID;

    public void setExpiringCodeStore(ExpiringCodeStore expiringCodeStore) {
        this.expiringCodeStore = expiringCodeStore;
    }

    public void setPasswordValidator(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    public void setProviderProvisioning(IdentityProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    public void setZoneAwareAuthenticationManager(DynamicZoneAwareAuthenticationManager zoneAwareAuthenticationManager) {
        this.zoneAwareAuthenticationManager = zoneAwareAuthenticationManager;
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    public InvitationsController(InvitationsService invitationsService) {
        this.invitationsService = invitationsService;
    }

    public String getSpEntityID() {
        return this.spEntityID;
    }

    public void setSpEntityID(String spEntityID) {
        this.spEntityID = spEntityID;
    }

    @RequestMapping(value={"/sent", "/new", "/new.do"})
    public void return404(HttpServletResponse response) {
        response.setStatus(404);
    }

    @RequestMapping(value={"/accept"}, method={RequestMethod.GET}, params={"code"})
    public String acceptInvitePage(@RequestParam String code, Model model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ExpiringCode expiringCode = this.expiringCodeStore.retrieveCode(code);
        if (null == expiringCode || null != expiringCode.getIntent() && !ExpiringCodeType.INVITATION.name().equals(expiringCode.getIntent())) {
            return this.handleUnprocessableEntity(model, response, "error_message_code", "code_expired", "invitations/accept_invite");
        }
        this.transferErrorParameters(model, request);
        Map codeData = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
        String origin = (String)codeData.get("origin");
        try {
            IdentityProvider provider = this.providerProvisioning.retrieveByOrigin(origin, IdentityZoneHolder.get().getId());
            String newCode = this.expiringCodeStore.generateCode(expiringCode.getData(), new Timestamp(System.currentTimeMillis() + 600000L), expiringCode.getIntent()).getCode();
            UaaUser user = this.userDatabase.retrieveUserById((String)codeData.get("user_id"));
            if (user.isVerified()) {
                InvitationsService.AcceptedInvitation accepted = this.invitationsService.acceptInvitation(newCode, "");
                String redirect = "redirect:" + accepted.getRedirectUri();
                logger.debug((Object)String.format("Redirecting accepted invitation for email:%s, id:%s to URL:%s", codeData.get("email"), codeData.get("user_id"), redirect));
                return redirect;
            }
            if ("saml".equals(provider.getType())) {
                this.setRequestAttributes(request, newCode, user);
                SamlIdentityProviderDefinition definition = (SamlIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), SamlIdentityProviderDefinition.class);
                String redirect = "redirect:/" + SamlRedirectUtils.getIdpRedirectUrl(definition, this.getSpEntityID());
                logger.debug((Object)String.format("Redirecting invitation for email:%s, id:%s single SAML IDP URL:%s", codeData.get("email"), codeData.get("user_id"), redirect));
                return redirect;
            }
            if ("oidc1.0".equals(provider.getType()) || "oauth2.0".equals(provider.getType())) {
                this.setRequestAttributes(request, newCode, user);
                AbstractXOAuthIdentityProviderDefinition definition = (AbstractXOAuthIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), AbstractXOAuthIdentityProviderDefinition.class);
                String scheme = request.getScheme();
                String host = request.getHeader("Host");
                String contextPath = request.getContextPath();
                String resultPath = scheme + "://" + host + contextPath;
                String redirect = "redirect:" + definition.getAuthUrl() + "?client_id=" + definition.getRelyingPartyId() + "&response_type=code&redirect_uri=" + resultPath + "/login/callback/" + provider.getOriginKey();
                logger.debug((Object)String.format("Redirecting invitation for email:%s, id:%s OIDC IDP URL:%s", codeData.get("email"), codeData.get("user_id"), redirect));
                return redirect;
            }
            UaaPrincipal uaaPrincipal = new UaaPrincipal((String)codeData.get("user_id"), (String)codeData.get("email"), (String)codeData.get("email"), origin, null, IdentityZoneHolder.get().getId());
            AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("scim.invite", (Object)uaaPrincipal, Arrays.asList(UaaAuthority.UAA_INVITED));
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            model.addAttribute("provider", (Object)provider.getType());
            model.addAttribute("code", (Object)newCode);
            model.addAttribute("email", codeData.get("email"));
            logger.debug((Object)String.format("Sending user to accept invitation page email:%s, id:%s", codeData.get("email"), codeData.get("user_id")));
            return "invitations/accept_invite";
        }
        catch (EmptyResultDataAccessException noProviderFound) {
            logger.debug((Object)String.format("No available invitation providers for email:%s, id:%s", codeData.get("email"), codeData.get("user_id")));
            return this.handleUnprocessableEntity(model, response, "error_message_code", "no_suitable_idp", "invitations/accept_invite");
        }
    }

    public void transferErrorParameters(Model model, HttpServletRequest request) {
        for (String p : Arrays.asList("error_message_code", "error_code", "error_message")) {
            if (!StringUtils.hasText((String)request.getParameter(p))) continue;
            model.addAttribute(p, (Object)request.getParameter(p));
        }
    }

    private void setRequestAttributes(HttpServletRequest request, String newCode, UaaUser user) {
        RequestContextHolder.getRequestAttributes().setAttribute("IS_INVITE_ACCEPTANCE", (Object)true, 1);
        RequestContextHolder.getRequestAttributes().setAttribute("user_id", (Object)user.getId(), 1);
        HttpServletRequestWrapper wrapper = this.getNewCodeWrapper(request, newCode);
        DefaultSavedRequest savedRequest = new DefaultSavedRequest((HttpServletRequest)wrapper, (PortResolver)new PortResolverImpl());
        RequestContextHolder.getRequestAttributes().setAttribute("SPRING_SECURITY_SAVED_REQUEST", (Object)savedRequest, 1);
    }

    protected HttpServletRequestWrapper getNewCodeWrapper(HttpServletRequest request, final String newCode) {
        return new HttpServletRequestWrapper(request){

            public String getParameter(String name) {
                if ("code".equals(name)) {
                    return newCode;
                }
                return super.getParameter(name);
            }

            public Map<String, String[]> getParameterMap() {
                Map result = super.getParameterMap();
                HashMap<String, String[]> modified = new HashMap<String, String[]>(result);
                modified.remove("code");
                modified.put("code", new String[]{newCode});
                return modified;
            }

            public Enumeration<String> getParameterNames() {
                return super.getParameterNames();
            }

            public String[] getParameterValues(String name) {
                if ("code".equals(name)) {
                    return new String[]{newCode};
                }
                return super.getParameterValues(name);
            }

            public String getQueryString() {
                return "code=" + newCode;
            }
        };
    }

    @RequestMapping(value={"/accept.do"}, method={RequestMethod.POST})
    public String acceptInvitation(@RequestParam(value="password") String password, @RequestParam(value="password_confirmation") String passwordConfirmation, @RequestParam(value="code") String code, Model model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InvitationsService.AcceptedInvitation invitation;
        PasswordConfirmationValidation validation = new PasswordConfirmationValidation(password, passwordConfirmation);
        UaaPrincipal principal = (UaaPrincipal)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        ExpiringCode expiringCode = this.expiringCodeStore.retrieveCode(code);
        if (expiringCode == null || expiringCode.getData() == null) {
            logger.debug((Object)"Failing invitation. Code not found.");
            SecurityContextHolder.clearContext();
            return this.handleUnprocessableEntity(model, response, "error_message_code", "code_expired", "invitations/accept_invite");
        }
        Map data = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
        if (principal == null || data.get("user_id") == null || !((String)data.get("user_id")).equals(principal.getId())) {
            logger.debug((Object)"Failing invitation. Code and user ID mismatch.");
            SecurityContextHolder.clearContext();
            return this.handleUnprocessableEntity(model, response, "error_message_code", "code_expired", "invitations/accept_invite");
        }
        String newCode = this.expiringCodeStore.generateCode(expiringCode.getData(), new Timestamp(System.currentTimeMillis() + 600000L), expiringCode.getIntent()).getCode();
        if (!validation.valid()) {
            return this.processErrorReload(newCode, model, principal.getEmail(), response, "error_message_code", validation.getMessageCode());
        }
        try {
            this.passwordValidator.validate(password);
        }
        catch (InvalidPasswordException e) {
            return this.processErrorReload(newCode, model, principal.getEmail(), response, "error_message", e.getMessagesAsOneString());
        }
        try {
            invitation = this.invitationsService.acceptInvitation(newCode, password);
        }
        catch (HttpClientErrorException e) {
            return this.handleUnprocessableEntity(model, response, "error_message_code", "code_expired", "invitations/accept_invite");
        }
        principal = new UaaPrincipal(invitation.getUser().getId(), invitation.getUser().getUserName(), invitation.getUser().getPrimaryEmail(), invitation.getUser().getOrigin(), invitation.getUser().getExternalId(), IdentityZoneHolder.get().getId());
        UaaAuthentication authentication = new UaaAuthentication(principal, UaaAuthority.USER_AUTHORITIES, new UaaAuthenticationDetails(request));
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        return "redirect:" + invitation.getRedirectUri();
    }

    private String processErrorReload(String code, Model model, String email, HttpServletResponse response, String errorCode, String error) {
        ExpiringCode expiringCode = this.expiringCodeStore.retrieveCode(code);
        Map codeData = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
        try {
            String origin = (String)codeData.get("origin");
            IdentityProvider provider = this.providerProvisioning.retrieveByOrigin(origin, IdentityZoneHolder.get().getId());
            String newCode = this.expiringCodeStore.generateCode(expiringCode.getData(), new Timestamp(System.currentTimeMillis() + 600000L), expiringCode.getIntent()).getCode();
            model.addAttribute(errorCode, (Object)error);
            model.addAttribute("code", (Object)newCode);
            return "redirect:accept";
        }
        catch (EmptyResultDataAccessException noProviderFound) {
            logger.debug((Object)String.format("No available invitation providers for email:%s, id:%s", codeData.get("email"), codeData.get("user_id")));
            return this.handleUnprocessableEntity(model, response, "error_message_code", "no_suitable_idp", "invitations/accept_invite");
        }
    }

    @RequestMapping(value={"/accept_enterprise.do"}, method={RequestMethod.POST})
    public String acceptLdapInvitation(@RequestParam(value="enterprise_username") String username, @RequestParam(value="enterprise_password") String password, @RequestParam(value="enterprise_email") String email, @RequestParam(value="code") String code, Model model, HttpServletResponse response) throws IOException {
        ExpiringCode expiringCode = this.expiringCodeStore.retrieveCode(code);
        if (expiringCode == null) {
            return this.handleUnprocessableEntity(model, response, "error_message_code", "code_expired", "invitations/accept_enterprise.do");
        }
        String newCode = this.expiringCodeStore.generateCode(expiringCode.getData(), new Timestamp(System.currentTimeMillis() + 600000L), null).getCode();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        AuthenticationManager authenticationManager = null;
        IdentityProvider ldapProvider = null;
        try {
            ldapProvider = this.providerProvisioning.retrieveByOrigin("ldap", IdentityZoneHolder.get().getId());
            this.zoneAwareAuthenticationManager.getLdapAuthenticationManager(IdentityZoneHolder.get(), ldapProvider).getLdapAuthenticationManager();
            authenticationManager = this.zoneAwareAuthenticationManager.getLdapAuthenticationManager(IdentityZoneHolder.get(), ldapProvider).getLdapManagerActual();
        }
        catch (EmptyResultDataAccessException e) {
            return this.handleUnprocessableEntity(model, response, "error_message_code", "no_suitable_idp", "invitations/accept_invite");
        }
        catch (Exception x) {
            logger.error((Object)"Unable to retrieve LDAP config.", (Throwable)x);
            return this.handleUnprocessableEntity(model, response, "error_message_code", "no_suitable_idp", "invitations/accept_invite");
        }
        try {
            Authentication authentication = authenticationManager.authenticate((Authentication)token);
            Map data = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
            ScimUser user = (ScimUser)this.userProvisioning.retrieve((String)data.get("user_id"));
            if (!user.getPrimaryEmail().equalsIgnoreCase(((ExtendedLdapUserDetails)authentication.getPrincipal()).getEmailAddress())) {
                model.addAttribute("email", data.get("email"));
                model.addAttribute("provider", (Object)"ldap");
                model.addAttribute("code", (Object)this.expiringCodeStore.generateCode(expiringCode.getData(), new Timestamp(System.currentTimeMillis() + 600000L), null).getCode());
                return this.handleUnprocessableEntity(model, response, "error_message", "invite.email_mismatch", "invitations/accept_invite");
            }
            if (authentication.isAuthenticated()) {
                user.setUserName(((ExtendedLdapUserDetails)authentication.getPrincipal()).getUsername());
                this.userProvisioning.update(user.getId(), user);
                SecurityContextHolder.getContext().setAuthentication(this.zoneAwareAuthenticationManager.getLdapAuthenticationManager(IdentityZoneHolder.get(), ldapProvider).authenticate((Authentication)token));
                InvitationsService.AcceptedInvitation accept = this.invitationsService.acceptInvitation(newCode, "");
                return "redirect:" + accept.getRedirectUri();
            }
            return this.handleUnprocessableEntity(model, response, "error_message", "not authenticated", "invitations/accept_invite");
        }
        catch (AuthenticationException x) {
            return this.handleUnprocessableEntity(model, response, "error_message", x.getMessage(), "invitations/accept_invite");
        }
        catch (Exception x) {
            logger.error((Object)"Unable to authenticate against LDAP", (Throwable)x);
            model.addAttribute("ldap", (Object)true);
            model.addAttribute("email", (Object)email);
            return this.handleUnprocessableEntity(model, response, "error_message", "bad_credentials", "invitations/accept_invite");
        }
    }

    private String handleUnprocessableEntity(Model model, HttpServletResponse response, String attributeKey, String attributeValue, String view) {
        model.addAttribute(attributeKey, (Object)attributeValue);
        response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
        return view;
    }

    public void setUserProvisioning(ScimUserProvisioning userProvisioning) {
        this.userProvisioning = userProvisioning;
    }
}

