/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cloudfoundry.identity.uaa.cache.UrlContentCache;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.RestTemplateFactory;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;

public class XOAuthProviderConfigurator
implements IdentityProviderProvisioning {
    private final IdentityProviderProvisioning providerProvisioning;
    private final UrlContentCache contentCache;
    private final RestTemplateFactory restTemplateFactory;

    public XOAuthProviderConfigurator(IdentityProviderProvisioning providerProvisioning, UrlContentCache contentCache, RestTemplateFactory restTemplateFactory) {
        this.providerProvisioning = providerProvisioning;
        this.contentCache = contentCache;
        this.restTemplateFactory = restTemplateFactory;
    }

    protected OIDCIdentityProviderDefinition overlay(OIDCIdentityProviderDefinition definition) {
        if (definition.getDiscoveryUrl() == null) {
            return definition;
        }
        byte[] oidcJson = this.contentCache.getUrlContent(definition.getDiscoveryUrl().toString(), this.restTemplateFactory.getRestTemplate(definition.isSkipSslValidation()));
        Map oidcConfig = (Map)JsonUtils.readValue((byte[])oidcJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        OIDCIdentityProviderDefinition overlayedDefinition = null;
        try {
            overlayedDefinition = (OIDCIdentityProviderDefinition)definition.clone();
            URL authorizationEndpoint = new URL((String)oidcConfig.get("authorization_endpoint"));
            URL userinfoEndpoint = new URL((String)oidcConfig.get("userinfo_endpoint"));
            URL tokenEndpoint = new URL((String)oidcConfig.get("token_endpoint"));
            URL tokenKeyUrl = new URL((String)oidcConfig.get("jwks_uri"));
            String issuer = (String)oidcConfig.get("issuer");
            overlayedDefinition.setAuthUrl(Optional.ofNullable(overlayedDefinition.getAuthUrl()).orElse(authorizationEndpoint));
            overlayedDefinition.setUserInfoUrl(Optional.ofNullable(overlayedDefinition.getUserInfoUrl()).orElse(userinfoEndpoint));
            overlayedDefinition.setTokenUrl(Optional.ofNullable(overlayedDefinition.getTokenUrl()).orElse(tokenEndpoint));
            overlayedDefinition.setIssuer(Optional.ofNullable(overlayedDefinition.getIssuer()).orElse(issuer));
            overlayedDefinition.setTokenKeyUrl(Optional.ofNullable(overlayedDefinition.getTokenKeyUrl()).orElse(tokenKeyUrl));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        return overlayedDefinition;
    }

    public String getCompleteAuthorizationURI(String alias, String baseURL, AbstractXOAuthIdentityProviderDefinition definition) {
        try {
            String authUrlBase = definition.getAuthUrl().toString();
            String queryAppendDelimiter = authUrlBase.contains("?") ? "&" : "?";
            ArrayList<String> query = new ArrayList<String>();
            query.add("client_id=" + definition.getRelyingPartyId());
            query.add("response_type=" + URLEncoder.encode(definition.getResponseType(), "UTF-8"));
            query.add("redirect_uri=" + URLEncoder.encode(baseURL + "/login/callback/" + alias, "UTF-8"));
            if (definition.getScopes() != null && !definition.getScopes().isEmpty()) {
                query.add("scope=" + URLEncoder.encode(String.join((CharSequence)" ", definition.getScopes()), "UTF-8"));
            }
            if (OIDCIdentityProviderDefinition.class.equals((Object)definition.getParameterizedClass())) {
                RandomValueStringGenerator nonceGenerator = new RandomValueStringGenerator(12);
                query.add("nonce=" + nonceGenerator.generate());
            }
            String queryString = String.join((CharSequence)"&", query);
            return authUrlBase + queryAppendDelimiter + queryString;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IdentityProvider create(IdentityProvider identityProvider) {
        return this.providerProvisioning.create(identityProvider);
    }

    @Override
    public IdentityProvider update(IdentityProvider identityProvider) {
        return this.providerProvisioning.update(identityProvider);
    }

    @Override
    public IdentityProvider retrieve(String id) {
        IdentityProvider p = this.providerProvisioning.retrieve(id);
        if (p != null && p.getType().equals("oidc1.0")) {
            p.setConfig((AbstractIdentityProviderDefinition)this.overlay((OIDCIdentityProviderDefinition)p.getConfig()));
        }
        return p;
    }

    @Override
    public List<IdentityProvider> retrieveActive(String zoneId) {
        return this.retrieveAll(true, zoneId);
    }

    @Override
    public List<IdentityProvider> retrieveAll(boolean activeOnly, String zoneId) {
        List<String> types = Arrays.asList("oauth2.0", "oidc1.0");
        List<IdentityProvider> providers = this.providerProvisioning.retrieveAll(activeOnly, zoneId);
        return Optional.ofNullable(providers).orElse(Collections.emptyList()).stream().filter(p -> types.contains(p.getType())).map(p -> {
            if (p.getType().equals("oidc1.0")) {
                p.setConfig((AbstractIdentityProviderDefinition)this.overlay((OIDCIdentityProviderDefinition)p.getConfig()));
            }
            return p;
        }).collect(Collectors.toList());
    }

    @Override
    public IdentityProvider retrieveByOrigin(String origin, String zoneId) {
        IdentityProvider p = this.providerProvisioning.retrieveByOrigin(origin, zoneId);
        if (p != null && p.getType().equals("oidc1.0")) {
            p.setConfig((AbstractIdentityProviderDefinition)this.overlay((OIDCIdentityProviderDefinition)p.getConfig()));
        }
        return p;
    }
}

