/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.MetadataProviderNotFoundException;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.websso.WebSSOProfileOptions;

public class LoginSamlEntryPoint
extends SAMLEntryPoint {
    private SamlIdentityProviderConfigurator providerDefinitionList;

    public SamlIdentityProviderConfigurator getProviderDefinitionList() {
        return this.providerDefinitionList;
    }

    public void setProviderDefinitionList(SamlIdentityProviderConfigurator providerDefinitionList) {
        this.providerDefinitionList = providerDefinitionList;
    }

    protected WebSSOProfileOptions getProfileOptions(SAMLMessageContext context, AuthenticationException exception) throws MetadataProviderException {
        ExtendedMetadata extendedMetadata;
        WebSSOProfileOptions options = super.getProfileOptions(context, exception);
        String idpEntityId = context.getPeerEntityId();
        if (idpEntityId != null && (extendedMetadata = this.metadata.getExtendedMetadata(idpEntityId)) != null) {
            String alias = extendedMetadata.getAlias();
            SamlIdentityProviderDefinition def = this.getIDPDefinition(alias);
            if (def.getNameID() != null) {
                options.setNameID(def.getNameID());
            }
            if (def.getAssertionConsumerIndex() >= 0) {
                options.setAssertionConsumerIndex(Integer.valueOf(def.getAssertionConsumerIndex()));
            }
        }
        return options;
    }

    private SamlIdentityProviderDefinition getIDPDefinition(String alias) throws MetadataProviderException {
        if (alias != null) {
            for (SamlIdentityProviderDefinition def : this.getProviderDefinitionList().getIdentityProviderDefinitions()) {
                if (!alias.equals(def.getIdpEntityAlias()) || !IdentityZoneHolder.get().getId().equals(def.getZoneId())) continue;
                return def;
            }
        }
        throw new MetadataProviderNotFoundException("Unable to find SAML provider for alias:" + alias);
    }
}

