/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cloudfoundry.identity.uaa.account.ChangeEmailService;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.message.MessageService;
import org.cloudfoundry.identity.uaa.message.MessageType;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.util.StringUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public class EmailChangeEmailService
implements ChangeEmailService {
    private final TemplateEngine templateEngine;
    private final MessageService messageService;
    private final ScimUserProvisioning scimUserProvisioning;
    private final ExpiringCodeStore codeStore;
    private final ClientDetailsService clientDetailsService;
    private static final int EMAIL_CHANGE_LIFETIME = 1800000;
    public static final String CHANGE_EMAIL_REDIRECT_URL = "change_email_redirect_url";
    private final String companyName;

    public EmailChangeEmailService(TemplateEngine templateEngine, MessageService messageService, ScimUserProvisioning scimUserProvisioning, String companyName, ExpiringCodeStore codeStore, ClientDetailsService clientDetailsService) {
        this.templateEngine = templateEngine;
        this.messageService = messageService;
        this.scimUserProvisioning = scimUserProvisioning;
        this.companyName = companyName;
        this.codeStore = codeStore;
        this.clientDetailsService = clientDetailsService;
    }

    @Override
    public void beginEmailChange(String userId, String email, String newEmail, String clientId, String redirectUri) {
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId);
        List results = this.scimUserProvisioning.query("userName eq \"" + newEmail + "\" and origin eq \"" + "uaa" + "\"");
        if (user.getUserName().equals(user.getPrimaryEmail()) && !results.isEmpty()) {
            throw new UaaException("Conflict", 409);
        }
        String code = this.generateExpiringCode(userId, newEmail, clientId, redirectUri);
        String htmlContent = this.getEmailChangeEmailHtml(email, newEmail, code);
        if (htmlContent != null) {
            String subject = this.getSubjectText();
            this.messageService.sendMessage(newEmail, MessageType.CHANGE_EMAIL, subject, htmlContent);
        }
    }

    private String generateExpiringCode(String userId, String newEmail, String clientId, String redirectUri) {
        HashMap<String, String> codeData = new HashMap<String, String>();
        codeData.put("user_id", userId);
        codeData.put("client_id", clientId);
        codeData.put("redirect_uri", redirectUri);
        codeData.put("email", newEmail);
        return this.codeStore.generateCode(JsonUtils.writeValueAsString(codeData), new Timestamp(System.currentTimeMillis() + 1800000L), null).getCode();
    }

    @Override
    public Map<String, String> completeVerification(String code) {
        ExpiringCode expiringCode = this.codeStore.retrieveCode(code);
        if (expiringCode == null) {
            throw new UaaException("Error", 400);
        }
        Map codeData = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
        String userId = (String)codeData.get("user_id");
        String email = (String)codeData.get("email");
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId);
        if (user.getUserName().equals(user.getPrimaryEmail())) {
            user.setUserName(email);
        }
        user.setPrimaryEmail(email);
        this.scimUserProvisioning.update(userId, user);
        String clientId = (String)codeData.get("client_id");
        String redirectLocation = null;
        if (clientId != null) {
            String redirectUri = codeData.get("redirect_uri") == null ? "" : (String)codeData.get("redirect_uri");
            try {
                ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
                Set redirectUris = clientDetails.getRegisteredRedirectUri() == null ? Collections.emptySet() : clientDetails.getRegisteredRedirectUri();
                Set<Pattern> wildcards = UaaStringUtils.constructWildcards(redirectUris);
                redirectLocation = UaaStringUtils.matches(wildcards, redirectUri) ? redirectUri : (String)clientDetails.getAdditionalInformation().get(CHANGE_EMAIL_REDIRECT_URL);
            }
            catch (NoSuchClientException noSuchClientException) {
                // empty catch block
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("userId", user.getId());
        result.put("username", user.getUserName());
        result.put("email", user.getPrimaryEmail());
        result.put("redirect_url", redirectLocation);
        return result;
    }

    private String getSubjectText() {
        if (IdentityZoneHolder.get().equals((Object)IdentityZone.getUaa())) {
            return StringUtils.hasText((String)this.companyName) ? this.companyName + " Email change verification" : "Account Email change verification";
        }
        return IdentityZoneHolder.get().getName() + " Email change verification";
    }

    private String getEmailChangeEmailHtml(String email, String newEmail, String code) {
        String verifyUrl = UaaUrlUtils.getUaaUrl("/verify_email");
        Context ctx = new Context();
        if (IdentityZoneHolder.get().equals((Object)IdentityZone.getUaa())) {
            ctx.setVariable("serviceName", (Object)(StringUtils.hasText((String)this.companyName) ? this.companyName : "Cloud Foundry"));
            ctx.setVariable("servicePhrase", (Object)(StringUtils.hasText((String)this.companyName) ? "a " + this.companyName + " account" : "an account"));
        } else {
            ctx.setVariable("serviceName", (Object)IdentityZoneHolder.get().getName());
            ctx.setVariable("servicePhrase", (Object)IdentityZoneHolder.get().getName());
        }
        ctx.setVariable("code", (Object)code);
        ctx.setVariable("newEmail", (Object)newEmail);
        ctx.setVariable("email", (Object)email);
        ctx.setVariable("verifyUrl", (Object)verifyUrl);
        return this.templateEngine.process("verify_email", (IContext)ctx);
    }
}

