/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;

public abstract class AbstractClientParametersAuthenticationFilter
implements Filter {
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected AuthenticationManager clientAuthenticationManager;
    protected AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();

    public AuthenticationManager getClientAuthenticationManager() {
        return this.clientAuthenticationManager;
    }

    public void setClientAuthenticationManager(AuthenticationManager clientAuthenticationManager) {
        this.clientAuthenticationManager = clientAuthenticationManager;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        Map<String, String> loginInfo = this.getCredentials(req);
        String clientId = loginInfo.get(CLIENT_ID);
        this.wrapClientCredentialLogin(req, res, loginInfo, clientId);
        chain.doFilter(request, response);
    }

    public abstract void wrapClientCredentialLogin(HttpServletRequest var1, HttpServletResponse var2, Map<String, String> var3, String var4) throws IOException, ServletException;

    protected void doClientCredentialLogin(HttpServletRequest req, Map<String, String> loginInfo, String clientId) {
        Authentication clientAuth = this.performClientAuthentication(req, loginInfo, clientId);
        SecurityContextHolder.getContext().setAuthentication(clientAuth);
    }

    private Map<String, String> getSingleValueMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map parameters = request.getParameterMap();
        Iterator iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String[] values = (String[])parameters.get(key = (String)iterator.next());
            map.put(key, values != null && values.length > 0 ? values[0] : null);
        }
        return map;
    }

    private Collection<String> getScope(HttpServletRequest request) {
        return OAuth2Utils.parseParameterList((String)request.getParameter("scope"));
    }

    private Authentication performClientAuthentication(HttpServletRequest req, Map<String, String> loginInfo, String clientId) {
        String clientSecret = loginInfo.get(CLIENT_SECRET);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)clientId, (Object)clientSecret);
        authentication.setDetails((Object)new UaaAuthenticationDetails(req, clientId));
        try {
            Authentication auth = this.clientAuthenticationManager.authenticate((Authentication)authentication);
            if (auth == null || !auth.isAuthenticated()) {
                throw new BadCredentialsException("Client Authentication failed.");
            }
            loginInfo.remove(CLIENT_SECRET);
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(clientId, this.getScope(req));
            authorizationRequest.setRequestParameters(this.getSingleValueMap(req));
            authorizationRequest.setApproved(true);
            OAuth2Authentication result = new OAuth2Authentication(authorizationRequest.createOAuth2Request(), null);
            result.setAuthenticated(true);
            return result;
        }
        catch (AuthenticationException e) {
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.debug((Object)("Unable to authenticate client: " + clientId), (Throwable)e);
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> getCredentials(HttpServletRequest request) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put(CLIENT_ID, request.getParameter(CLIENT_ID));
        credentials.put(CLIENT_SECRET, request.getParameter(CLIENT_SECRET));
        return credentials;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

