/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.KeystoneIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;
import org.cloudfoundry.identity.uaa.provider.PasswordPolicy;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.LdapUtils;
import org.cloudfoundry.identity.uaa.util.UaaMapUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.json.JSONException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.dao.EmptyResultDataAccessException;

public class IdentityProviderBootstrap
implements InitializingBean {
    private IdentityProviderProvisioning provisioning;
    private List<IdentityProvider> providers = new LinkedList<IdentityProvider>();
    private SamlIdentityProviderConfigurator configurator;
    private Map<String, Object> ldapConfig;
    private Map<String, Object> keystoneConfig;
    private Environment environment;
    private PasswordPolicy defaultPasswordPolicy;
    private LockoutPolicy defaultLockoutPolicy;
    private boolean disableInternalUserManagement;

    public IdentityProviderBootstrap(IdentityProviderProvisioning provisioning, Environment environment) {
        if (provisioning == null) {
            throw new NullPointerException("Constructor argument can't be null.");
        }
        this.provisioning = provisioning;
        this.environment = environment;
    }

    public void setSamlProviders(SamlIdentityProviderConfigurator configurator) {
        this.configurator = configurator;
    }

    protected void addSamlProviders() {
        if (this.configurator == null) {
            return;
        }
        for (SamlIdentityProviderDefinition def : this.configurator.getIdentityProviderDefinitions()) {
            IdentityProvider provider = new IdentityProvider();
            provider.setType("saml");
            provider.setOriginKey(def.getIdpEntityAlias());
            provider.setName("UAA SAML Identity Provider[" + provider.getOriginKey() + "]");
            provider.setActive(true);
            try {
                provider.setConfig((AbstractIdentityProviderDefinition)def);
            }
            catch (JsonUtils.JsonUtilException x) {
                throw new RuntimeException("Non serializable LDAP config");
            }
            this.providers.add(provider);
        }
    }

    public void setLdapConfig(HashMap<String, Object> ldapConfig) {
        this.ldapConfig = ldapConfig;
    }

    protected void addLdapProvider() {
        boolean ldapProfile = Arrays.asList(this.environment.getActiveProfiles()).contains("ldap");
        if (this.ldapConfig != null || ldapProfile) {
            IdentityProvider provider = new IdentityProvider();
            provider.setActive(ldapProfile);
            provider.setOriginKey("ldap");
            provider.setType("ldap");
            provider.setName("UAA LDAP Provider");
            HashMap<String, Object> ldap = new HashMap<String, Object>();
            ldap.put("ldap", this.ldapConfig);
            LdapIdentityProviderDefinition json = this.getLdapConfigAsDefinition(ldap);
            provider.setConfig((AbstractIdentityProviderDefinition)json);
            provider.setActive(ldapProfile && json.isConfigured() != false);
            this.providers.add(provider);
        }
    }

    protected LdapIdentityProviderDefinition getLdapConfigAsDefinition(Map<String, Object> ldapConfig) {
        ldapConfig = UaaMapUtils.flatten(ldapConfig);
        this.populateLdapEnvironment(ldapConfig);
        if (ldapConfig.isEmpty()) {
            return new LdapIdentityProviderDefinition();
        }
        return LdapUtils.fromConfig(ldapConfig);
    }

    protected void populateLdapEnvironment(Map<String, Object> ldapConfig) {
        AbstractEnvironment env = (AbstractEnvironment)this.environment;
        for (String property : LdapIdentityProviderDefinition.LDAP_PROPERTY_NAMES) {
            if (!env.containsProperty(property) || LdapIdentityProviderDefinition.LDAP_PROPERTY_TYPES.get(property) == null) continue;
            ldapConfig.put(property, env.getProperty(property, (Class)LdapIdentityProviderDefinition.LDAP_PROPERTY_TYPES.get(property)));
        }
        Map<String, Object> stringProperties = UaaMapUtils.getPropertiesStartingWith((ConfigurableEnvironment)env, "ldap.");
        for (Map.Entry<String, Object> entry : stringProperties.entrySet()) {
            if (LdapIdentityProviderDefinition.LDAP_PROPERTY_NAMES.contains(entry.getKey())) continue;
            ldapConfig.put(entry.getKey(), entry.getValue());
        }
    }

    public void setKeystoneConfig(HashMap<String, Object> keystoneConfig) {
        this.keystoneConfig = keystoneConfig;
    }

    protected AbstractIdentityProviderDefinition getKeystoneDefinition(Map<String, Object> config) {
        return new KeystoneIdentityProviderDefinition(config);
    }

    protected void addKeystoneProvider() {
        boolean keystoneProfile = Arrays.asList(this.environment.getActiveProfiles()).contains("keystone");
        if (this.keystoneConfig != null || keystoneProfile) {
            boolean active = keystoneProfile && this.keystoneConfig != null;
            IdentityProvider provider = new IdentityProvider();
            provider.setOriginKey("keystone");
            provider.setType("keystone");
            provider.setName("UAA Keystone Provider");
            provider.setActive(active);
            provider.setConfig(this.getKeystoneDefinition(this.keystoneConfig));
            this.providers.add(provider);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.providers.clear();
        this.addLdapProvider();
        this.addSamlProviders();
        this.addKeystoneProvider();
        String zoneId = IdentityZone.getUaa().getId();
        this.deactivateUnusedProviders(zoneId);
        for (IdentityProvider provider : this.providers) {
            IdentityProvider existing = null;
            try {
                existing = this.provisioning.retrieveByOrigin(provider.getOriginKey(), zoneId);
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                // empty catch block
            }
            provider.setIdentityZoneId(zoneId);
            if (existing == null) {
                this.provisioning.create(provider);
                continue;
            }
            provider.setId(existing.getId());
            provider.setCreated(existing.getCreated());
            provider.setVersion(existing.getVersion());
            provider.setLastModified(new Date(System.currentTimeMillis()));
            this.provisioning.update(provider);
        }
        this.updateDefaultZoneUaaIDP();
    }

    private void deactivateUnusedProviders(String zoneId) {
        for (IdentityProvider provider : this.provisioning.retrieveAll(false, zoneId)) {
            if (!"saml".equals(provider.getType()) && !"ldap".equals(provider.getType()) && !"keystone".equals(provider.getType()) || this.isAmongProviders(provider.getOriginKey())) continue;
            provider.setActive(false);
            this.provisioning.update(provider);
        }
    }

    protected void updateDefaultZoneUaaIDP() throws JSONException {
        IdentityProvider internalIDP = this.provisioning.retrieveByOrigin("uaa", IdentityZone.getUaa().getId());
        UaaIdentityProviderDefinition identityProviderDefinition = new UaaIdentityProviderDefinition(this.defaultPasswordPolicy, this.defaultLockoutPolicy, this.disableInternalUserManagement);
        internalIDP.setConfig((AbstractIdentityProviderDefinition)identityProviderDefinition);
        String disableInternalAuth = this.environment.getProperty("disableInternalAuth");
        internalIDP.setActive(!this.getBooleanValue(disableInternalAuth, false));
        this.provisioning.update(internalIDP);
    }

    protected boolean getBooleanValue(String s, boolean defaultValue) {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    private boolean isAmongProviders(String originKey) {
        for (IdentityProvider provider : this.providers) {
            if (!provider.getOriginKey().equals(originKey)) continue;
            return true;
        }
        return false;
    }

    public void setDefaultPasswordPolicy(PasswordPolicy defaultPasswordPolicy) {
        this.defaultPasswordPolicy = defaultPasswordPolicy;
    }

    public void setDefaultLockoutPolicy(LockoutPolicy defaultLockoutPolicy) {
        this.defaultLockoutPolicy = defaultLockoutPolicy;
    }

    public boolean isDisableInternalUserManagement() {
        return this.disableInternalUserManagement;
    }

    public void setDisableInternalUserManagement(boolean disableInternalUserManagement) {
        this.disableInternalUserManagement = disableInternalUserManagement;
    }
}

