/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.RsaSigner;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.jwt.crypto.sign.Signer;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SignerProvider {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String verifierKey;
    private String signingKey = this.verifierKey = new RandomValueStringGenerator().generate();
    private Signer signer = new MacSigner(this.verifierKey);
    private SignatureVerifier verifier = new MacSigner(this.signingKey);
    private String type = "MAC";
    private final Base64.Encoder base64encoder = Base64.getMimeEncoder(64, "\n".getBytes());
    private static Pattern PEM_DATA = Pattern.compile("-----BEGIN (.*)-----(.*)-----END (.*)-----", 32);

    public SignerProvider() {
        this(new RandomValueStringGenerator().generate());
    }

    public SignerProvider(String signingKey) {
        if (StringUtils.isEmpty((Object)signingKey)) {
            throw new IllegalArgumentException("Signing key cannot be empty");
        }
        this.setSigningKey(signingKey);
    }

    public Signer getSigner() {
        return this.signer;
    }

    public String getVerifierKey() {
        return this.verifierKey;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPublic() {
        return this.verifierKey.startsWith("-----BEGIN");
    }

    public SignatureVerifier getVerifier() {
        return this.verifier;
    }

    public String getRevocationHash(List<String> salts) {
        String result = "";
        for (String s : salts) {
            byte[] hashable = (result + "###" + s).getBytes();
            result = Integer.toHexString(SignerProvider.murmurhash3x8632(hashable, 0, hashable.length, 61680));
        }
        return result;
    }

    public void setSigningKey(String signingKey) {
        Assert.hasText((String)signingKey);
        this.signingKey = signingKey = signingKey.trim();
        if (this.isAssymetricKey(signingKey)) {
            KeyPair keyPair = SignerProvider.parseKeyPair(signingKey);
            this.signer = new RsaSigner(signingKey);
            this.pemEncodePublicKey(keyPair);
            this.logger.debug((Object)"Configured with RSA signing key");
            try {
                this.verifier = new RsaVerifier(this.verifierKey);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create an RSA verifier from verifierKey", e);
            }
            byte[] test = "test".getBytes();
            try {
                this.verifier.verify(test, this.signer.sign(test));
                this.logger.debug((Object)"Signing and verification RSA keys match");
            }
            catch (InvalidSignatureException e) {
                throw new RuntimeException("Signing and verification RSA keys do not match", e);
            }
            this.type = "RSA";
        } else {
            this.verifierKey = signingKey;
            MacSigner macSigner = new MacSigner(signingKey);
            this.signer = macSigner;
            this.verifier = macSigner;
            Assert.state((this.verifierKey == null || this.signingKey == this.verifierKey ? 1 : 0) != 0, (String)"For MAC signing you do not need to specify the verifier key separately, and if you do it must match the signing key");
            this.type = "MAC";
        }
    }

    protected void pemEncodePublicKey(KeyPair keyPair) {
        String begin = "-----BEGIN PUBLIC KEY-----\n";
        String end = "\n-----END PUBLIC KEY-----";
        byte[] data = keyPair.getPublic().getEncoded();
        String base64encoded = new String(this.base64encoder.encode(data));
        this.verifierKey = begin + base64encoded + end;
    }

    private boolean isAssymetricKey(String key) {
        return key.startsWith("-----BEGIN");
    }

    public static int murmurhash3x8632(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= c1;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    static KeyPair parseKeyPair(String pemData) {
        Matcher m = PEM_DATA.matcher(pemData.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("String is not PEM encoded data");
        }
        String type = m.group(1);
        byte[] content = Codecs.b64Decode((byte[])Codecs.utf8Encode((CharSequence)m.group(2)));
        PrivateKey privateKey = null;
        try {
            PublicKey publicKey;
            KeyFactory fact = KeyFactory.getInstance("RSA");
            if (type.equals("RSA PRIVATE KEY")) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)content);
                if (seq.size() != 9) {
                    throw new IllegalArgumentException("Invalid RSA Private Key ASN1 sequence.");
                }
                RSAPrivateKey key = RSAPrivateKey.getInstance((Object)seq);
                RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
                RSAPrivateCrtKeySpec privSpec = new RSAPrivateCrtKeySpec(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrime1(), key.getPrime2(), key.getExponent1(), key.getExponent2(), key.getCoefficient());
                publicKey = fact.generatePublic(pubSpec);
                privateKey = fact.generatePrivate(privSpec);
            } else if (type.equals("PUBLIC KEY")) {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(content);
                publicKey = fact.generatePublic(keySpec);
            } else if (type.equals("RSA PUBLIC KEY")) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)content);
                RSAPublicKey key = RSAPublicKey.getInstance((Object)seq);
                RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
                publicKey = fact.generatePublic(pubSpec);
            } else {
                throw new IllegalArgumentException(type + " is not a supported format");
            }
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

