/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.ComparableProvider;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.ExtendedMetadataProvider;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.trust.httpclient.TLSProtocolConfigurer;

public class ZoneAwareMetadataManager
extends MetadataManager
implements ExtendedMetadataProvider,
InitializingBean,
DisposableBean,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(ZoneAwareMetadataManager.class);
    private IdentityProviderProvisioning providerDao;
    private IdentityZoneProvisioning zoneDao;
    private SamlIdentityProviderConfigurator configurator;
    private KeyManager keyManager;
    private Map<IdentityZone, ExtensionMetadataManager> metadataManagers;
    private long refreshInterval = 30000L;
    private long lastRefresh = 0L;
    private Timer timer;
    private String beanName = ZoneAwareMetadataManager.class.getName() + "-" + System.identityHashCode((Object)this);

    public ZoneAwareMetadataManager(IdentityProviderProvisioning providerDao, IdentityZoneProvisioning zoneDao, SamlIdentityProviderConfigurator configurator, KeyManager keyManager) throws MetadataProviderException {
        super(Collections.emptyList());
        this.providerDao = providerDao;
        this.zoneDao = zoneDao;
        this.configurator = configurator;
        this.keyManager = keyManager;
        super.setKeyManager(keyManager);
        super.setRefreshCheckInterval(0L);
        if (this.metadataManagers == null) {
            this.metadataManagers = new ConcurrentHashMap<IdentityZone, ExtensionMetadataManager>();
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @PostConstruct
    public void checkAllProviders() throws MetadataProviderException {
        for (Map.Entry<IdentityZone, ExtensionMetadataManager> entry : this.metadataManagers.entrySet()) {
            entry.getValue().setKeyManager(this.keyManager);
        }
        this.refreshAllProviders();
        this.timer = new Timer("ZoneAwareMetadataManager.Refresh[" + this.beanName + "]", true);
        this.timer.schedule((TimerTask)new RefreshTask(), this.refreshInterval, this.refreshInterval);
    }

    protected void refreshAllProviders() throws MetadataProviderException {
        this.refreshAllProviders(true);
    }

    protected String getThreadNameAndId() {
        return Thread.currentThread().getName() + "-" + System.identityHashCode(Thread.currentThread());
    }

    protected void refreshAllProviders(boolean ignoreTimestamp) throws MetadataProviderException {
        logger.debug((Object)("Running SAML IDP refresh[" + this.getThreadNameAndId() + "] - ignoreTimestamp=" + ignoreTimestamp));
        for (IdentityZone zone : this.zoneDao.retrieveAll()) {
            ExtensionMetadataManager manager = this.getManager(zone);
            boolean hasChanges = false;
            LinkedList<SamlIdentityProviderDefinition> zoneDefinitions = new LinkedList<SamlIdentityProviderDefinition>(this.configurator.getIdentityProviderDefinitionsForZone(zone));
            for (IdentityProvider provider : this.providerDao.retrieveAll(false, zone.getId())) {
                zoneDefinitions.remove(provider.getConfig());
                if (!"saml".equals(provider.getType()) || !ignoreTimestamp && this.lastRefresh >= provider.getLastModified().getTime()) continue;
                try {
                    SamlIdentityProviderDefinition definition = (SamlIdentityProviderDefinition)provider.getConfig();
                    try {
                        if (provider.isActive()) {
                            this.log.info("Adding SAML IDP zone[" + zone.getId() + "] alias[" + definition.getIdpEntityAlias() + "]");
                            ExtendedMetadataDelegate[] delegates = this.configurator.addSamlIdentityProviderDefinition(definition);
                            if (delegates[1] != null) {
                                manager.removeMetadataProvider((MetadataProvider)delegates[1]);
                            }
                            manager.addMetadataProvider((MetadataProvider)delegates[0]);
                        } else {
                            this.removeSamlProvider(zone, manager, definition);
                        }
                        hasChanges = true;
                    }
                    catch (MetadataProviderException e) {
                        logger.error((Object)("Unable to refresh identity provider:" + definition), (Throwable)e);
                    }
                }
                catch (JsonUtils.JsonUtilException x) {
                    logger.error((Object)("Unable to load provider:" + provider), (Throwable)x);
                }
            }
            for (SamlIdentityProviderDefinition definition : zoneDefinitions) {
                this.removeSamlProvider(zone, manager, definition);
                hasChanges = true;
            }
            if (!hasChanges) continue;
            this.refreshZoneManager(manager);
        }
        this.lastRefresh = System.currentTimeMillis();
    }

    protected void removeSamlProvider(IdentityZone zone, ExtensionMetadataManager manager, SamlIdentityProviderDefinition definition) {
        this.log.info("Removing SAML IDP zone[" + zone.getId() + "] alias[" + definition.getIdpEntityAlias() + "]");
        ExtendedMetadataDelegate delegate = this.configurator.removeIdentityProviderDefinition(definition);
        if (delegate != null) {
            manager.removeMetadataProvider((MetadataProvider)delegate);
        }
    }

    public ExtensionMetadataManager getManager(IdentityZone zone) {
        ExtensionMetadataManager manager;
        if (this.metadataManagers == null) {
            this.metadataManagers = new ConcurrentHashMap<IdentityZone, ExtensionMetadataManager>();
        }
        if ((manager = this.metadataManagers.get(zone)) == null) {
            try {
                manager = new ExtensionMetadataManager(Collections.emptyList());
            }
            catch (MetadataProviderException e) {
                throw new IllegalStateException(e);
            }
            manager.setKeyManager(this.keyManager);
            ((ConcurrentHashMap)this.metadataManagers).putIfAbsent(zone, manager);
        }
        return this.metadataManagers.get(zone);
    }

    public ExtensionMetadataManager getManager() {
        return this.getManager(IdentityZoneHolder.get());
    }

    public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
        this.getManager().setProviders(newProviders);
    }

    public void refreshMetadata() {
        this.getManager().refreshMetadata();
    }

    public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
        this.getManager().addMetadataProvider(newProvider);
    }

    public void removeMetadataProvider(MetadataProvider provider) {
        this.getManager().removeMetadataProvider(provider);
    }

    public List<MetadataProvider> getProviders() {
        return this.getManager().getProviders();
    }

    public List<ExtendedMetadataDelegate> getAvailableProviders() {
        return this.getManager().getAvailableProviders();
    }

    protected void initializeProvider(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        this.getManager().initializeProvider(provider);
    }

    protected void initializeProviderData(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        this.getManager().initializeProviderData(provider);
    }

    protected void initializeProviderFilters(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        this.getManager().initializeProviderFilters(provider);
    }

    protected SignatureTrustEngine getTrustEngine(MetadataProvider provider) {
        return this.getManager().getTrustEngine(provider);
    }

    protected PKIXValidationInformationResolver getPKIXResolver(MetadataProvider provider, Set<String> trustedKeys, Set<String> trustedNames) {
        return this.getManager().getPKIXResolver(provider, trustedKeys, trustedNames);
    }

    protected List<String> parseProvider(MetadataProvider provider) throws MetadataProviderException {
        return this.getManager().parseProvider(provider);
    }

    public Set<String> getIDPEntityNames() {
        return this.getManager().getIDPEntityNames();
    }

    public Set<String> getSPEntityNames() {
        return this.getManager().getSPEntityNames();
    }

    public boolean isIDPValid(String idpID) {
        return this.getManager().isIDPValid(idpID);
    }

    public boolean isSPValid(String spID) {
        return this.getManager().isSPValid(spID);
    }

    public String getHostedSPName() {
        return this.getManager().getHostedSPName();
    }

    public void setHostedSPName(String hostedSPName) {
        this.getManager().setHostedSPName(hostedSPName);
    }

    public String getDefaultIDP() throws MetadataProviderException {
        return this.getManager().getDefaultIDP();
    }

    public void setDefaultIDP(String defaultIDP) {
        this.getManager().setDefaultIDP(defaultIDP);
    }

    public EntityDescriptor getEntityDescriptor(byte[] hash) throws MetadataProviderException {
        return this.getManager().getEntityDescriptor(hash);
    }

    public String getEntityIdForAlias(String entityAlias) throws MetadataProviderException {
        return this.getManager().getEntityIdForAlias(entityAlias);
    }

    public ExtendedMetadata getDefaultExtendedMetadata() {
        return this.getManager().getDefaultExtendedMetadata();
    }

    public void setDefaultExtendedMetadata(ExtendedMetadata defaultExtendedMetadata) {
        this.getManager().setDefaultExtendedMetadata(defaultExtendedMetadata);
    }

    public boolean isRefreshRequired() {
        return this.getManager().isRefreshRequired();
    }

    public void setRefreshRequired(boolean refreshRequired) {
        this.getManager().setRefreshRequired(refreshRequired);
    }

    public void setRefreshCheckInterval(long refreshCheckInterval) {
        this.refreshInterval = refreshCheckInterval;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.getManager().setKeyManager(keyManager);
    }

    public void setTLSConfigurer(TLSProtocolConfigurer configurer) {
        this.getManager().setTLSConfigurer(configurer);
    }

    protected void doAddMetadataProvider(MetadataProvider provider, List<MetadataProvider> providerList) {
        this.getManager().doAddMetadataProvider(provider, providerList);
    }

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        this.getManager().setRequireValidMetadata(requireValidMetadata);
    }

    public MetadataFilter getMetadataFilter() {
        return this.getManager().getMetadataFilter();
    }

    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        this.getManager().setMetadataFilter(newFilter);
    }

    public XMLObject getMetadata() throws MetadataProviderException {
        return this.getManager().getMetadata();
    }

    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        return this.getManager().getEntitiesDescriptor(name);
    }

    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        return this.getManager().getEntityDescriptor(entityID);
    }

    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        return this.getManager().getRole(entityID, roleName);
    }

    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        return this.getManager().getRole(entityID, roleName, supportedProtocol);
    }

    public List<ObservableMetadataProvider.Observer> getObservers() {
        return this.getManager().getObservers();
    }

    protected void emitChangeEvent() {
        this.getManager().emitChangeEvent();
    }

    public boolean requireValidMetadata() {
        return this.getManager().requireValidMetadata();
    }

    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
        for (Map.Entry<IdentityZone, ExtensionMetadataManager> manager : this.metadataManagers.entrySet()) {
            manager.getValue().destroy();
        }
        this.metadataManagers.clear();
        super.destroy();
    }

    public ExtendedMetadata getExtendedMetadata(String entityID) throws MetadataProviderException {
        return super.getExtendedMetadata(entityID);
    }

    protected Set<ComparableProvider> refreshZoneManager(ExtensionMetadataManager manager) {
        HashSet<ComparableProvider> result = new HashSet<ComparableProvider>();
        try {
            this.log.trace("Executing metadata refresh task");
            for (MetadataProvider provider : manager.getProviders()) {
                provider.getMetadata();
            }
            if (manager.isRefreshRequired()) {
                manager.refreshMetadata();
            }
            for (MetadataProvider provider : manager.getProviders()) {
                if (provider instanceof ComparableProvider) {
                    result.add((ComparableProvider)provider);
                    continue;
                }
                if (!(provider instanceof ExtendedMetadataDelegate) || !(((ExtendedMetadataDelegate)provider).getDelegate() instanceof ComparableProvider)) continue;
                result.add((ComparableProvider)((ExtendedMetadataDelegate)provider).getDelegate());
            }
        }
        catch (Throwable e) {
            this.log.warn("Metadata refreshing has failed", e);
        }
        return result;
    }

    public static class MetadataProviderObserver
    implements ObservableMetadataProvider.Observer {
        private ExtensionMetadataManager manager;

        public MetadataProviderObserver(ExtensionMetadataManager manager) {
            this.manager = manager;
        }

        public void onEvent(MetadataProvider provider) {
            this.manager.setRefreshRequired(true);
        }
    }

    public static class ExtensionMetadataManager
    extends CachingMetadataManager {
        public ExtensionMetadataManager(List<MetadataProvider> providers) throws MetadataProviderException {
            super(providers);
            this.setRefreshCheckInterval(0L);
        }

        public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
            return super.getEntityDescriptor(entityID);
        }

        public EntityDescriptor getEntityDescriptor(byte[] hash) throws MetadataProviderException {
            return super.getEntityDescriptor(hash);
        }

        public String getEntityIdForAlias(String entityAlias) throws MetadataProviderException {
            return super.getEntityIdForAlias(entityAlias);
        }

        public ExtendedMetadata getExtendedMetadata(String entityID) throws MetadataProviderException {
            return super.getExtendedMetadata(entityID);
        }

        public void refreshMetadata() {
            super.refreshMetadata();
        }

        public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
            ComparableProvider cp = null;
            if (newProvider instanceof ExtendedMetadataDelegate && ((ExtendedMetadataDelegate)newProvider).getDelegate() instanceof ComparableProvider) {
                cp = (ComparableProvider)((ExtendedMetadataDelegate)newProvider).getDelegate();
            } else {
                logger.warn((Object)("Adding Unknown SAML Provider type:" + (newProvider != null ? newProvider.getClass() : null) + ":" + newProvider));
            }
            for (MetadataProvider metadataProvider : this.getAvailableProviders()) {
                if (!newProvider.equals(metadataProvider)) continue;
                this.removeMetadataProvider(metadataProvider);
                if (cp == null) continue;
                logger.debug((Object)("Found duplicate SAML provider, removing before readding zone[" + cp.getZoneId() + "] alias[" + cp.getAlias() + "]"));
            }
            super.addMetadataProvider(newProvider);
            if (cp != null) {
                logger.debug((Object)("Added Metadata for SAML provider zone[" + cp.getZoneId() + "] alias[" + cp.getAlias() + "]"));
            }
        }

        public void destroy() {
            super.destroy();
        }

        public List<ExtendedMetadataDelegate> getAvailableProviders() {
            return super.getAvailableProviders();
        }

        public ExtendedMetadata getDefaultExtendedMetadata() {
            return super.getDefaultExtendedMetadata();
        }

        public String getDefaultIDP() throws MetadataProviderException {
            return super.getDefaultIDP();
        }

        public String getHostedSPName() {
            return super.getHostedSPName();
        }

        public Set<String> getIDPEntityNames() {
            return super.getIDPEntityNames();
        }

        public PKIXValidationInformationResolver getPKIXResolver(MetadataProvider provider, Set<String> trustedKeys, Set<String> trustedNames) {
            return super.getPKIXResolver(provider, trustedKeys, trustedNames);
        }

        public List<MetadataProvider> getProviders() {
            return super.getProviders();
        }

        public Set<String> getSPEntityNames() {
            return super.getSPEntityNames();
        }

        public SignatureTrustEngine getTrustEngine(MetadataProvider provider) {
            return super.getTrustEngine(provider);
        }

        public void initializeProvider(ExtendedMetadataDelegate provider) throws MetadataProviderException {
            super.initializeProvider(provider);
        }

        public void initializeProviderData(ExtendedMetadataDelegate provider) throws MetadataProviderException {
            super.initializeProviderData(provider);
        }

        public void initializeProviderFilters(ExtendedMetadataDelegate provider) throws MetadataProviderException {
            super.initializeProviderFilters(provider);
        }

        public boolean isIDPValid(String idpID) {
            return super.isIDPValid(idpID);
        }

        public boolean isRefreshRequired() {
            return super.isRefreshRequired();
        }

        public boolean isSPValid(String spID) {
            return super.isSPValid(spID);
        }

        public List<String> parseProvider(MetadataProvider provider) throws MetadataProviderException {
            return super.parseProvider(provider);
        }

        public void removeMetadataProvider(MetadataProvider provider) {
            ComparableProvider cp = null;
            if (provider instanceof ExtendedMetadataDelegate && ((ExtendedMetadataDelegate)provider).getDelegate() instanceof ComparableProvider) {
                cp = (ComparableProvider)((ExtendedMetadataDelegate)provider).getDelegate();
            } else {
                logger.warn((Object)("Removing Unknown SAML Provider type:" + (provider != null ? provider.getClass() : null) + ":" + provider));
            }
            super.removeMetadataProvider(provider);
            if (cp != null) {
                logger.debug((Object)("Removed Metadata for SAML provider zone[" + cp.getZoneId() + "] alias[" + cp.getAlias() + "]"));
            }
        }

        public void setDefaultExtendedMetadata(ExtendedMetadata defaultExtendedMetadata) {
            super.setDefaultExtendedMetadata(defaultExtendedMetadata);
        }

        public void setDefaultIDP(String defaultIDP) {
            super.setDefaultIDP(defaultIDP);
        }

        public void setHostedSPName(String hostedSPName) {
            super.setHostedSPName(hostedSPName);
        }

        public void setKeyManager(KeyManager keyManager) {
            super.setKeyManager(keyManager);
        }

        public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
            super.setProviders(newProviders);
        }

        public void setRefreshCheckInterval(long refreshCheckInterval) {
            super.setRefreshCheckInterval(refreshCheckInterval);
        }

        public void setRefreshRequired(boolean refreshRequired) {
            super.setRefreshRequired(refreshRequired);
        }

        public void setTLSConfigurer(TLSProtocolConfigurer configurer) {
            super.setTLSConfigurer(configurer);
        }

        public void doAddMetadataProvider(MetadataProvider provider, List<MetadataProvider> providerList) {
            super.doAddMetadataProvider(provider, providerList);
        }

        public void emitChangeEvent() {
            super.emitChangeEvent();
        }

        public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
            return super.getEntitiesDescriptor(name);
        }

        public XMLObject getMetadata() throws MetadataProviderException {
            return super.getMetadata();
        }

        public MetadataFilter getMetadataFilter() {
            return super.getMetadataFilter();
        }

        public List<ObservableMetadataProvider.Observer> getObservers() {
            return super.getObservers();
        }

        public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
            return super.getRole(entityID, roleName);
        }

        public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
            return super.getRole(entityID, roleName, supportedProtocol);
        }

        public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
            super.setMetadataFilter(newFilter);
        }

        public void setRequireValidMetadata(boolean requireValidMetadata) {
            super.setRequireValidMetadata(requireValidMetadata);
        }

        public boolean requireValidMetadata() {
            return super.requireValidMetadata();
        }
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                ZoneAwareMetadataManager.this.refreshAllProviders(false);
            }
            catch (Exception x) {
                ZoneAwareMetadataManager.this.log.error("Unable to run SAML provider refresh task:", (Throwable)x);
            }
        }
    }
}

