/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.StringUtils;

public class DomainFilter {
    private static Log logger = LogFactory.getLog(DomainFilter.class);

    public List<IdentityProvider> filter(List<IdentityProvider> activeProviders, ClientDetails client, String email) {
        if (!StringUtils.hasText((String)email)) {
            return Collections.EMPTY_LIST;
        }
        if (activeProviders != null && activeProviders.size() > 0) {
            List<String> clientFilter = this.getProvidersForClient(client);
            if (clientFilter != null) {
                activeProviders = activeProviders.stream().filter(p -> clientFilter.contains(p.getOriginKey())).collect(Collectors.toList());
            }
            if (email != null && email.contains("@")) {
                String domain = email.substring(email.indexOf(64) + 1);
                List<IdentityProvider> explicitlyMatched = activeProviders.stream().filter(p -> this.doesEmailDomainMatchProvider((IdentityProvider)p, domain, true)).collect(Collectors.toList());
                if (explicitlyMatched.size() > 0) {
                    return explicitlyMatched;
                }
                activeProviders = activeProviders.stream().filter(p -> this.doesEmailDomainMatchProvider((IdentityProvider)p, domain, false)).collect(Collectors.toList());
            }
        }
        return activeProviders != null ? activeProviders : Collections.EMPTY_LIST;
    }

    protected List<String> getProvidersForClient(ClientDetails client) {
        if (client == null) {
            return null;
        }
        return (List)client.getAdditionalInformation().get("allowedproviders");
    }

    protected List<String> getEmailDomain(IdentityProvider provider) {
        if (provider.getConfig() != null) {
            return provider.getConfig().getEmailDomain();
        }
        return null;
    }

    protected boolean doesEmailDomainMatchProvider(IdentityProvider provider, String domain, boolean explicit) {
        List<String> wildcardList;
        List<String> domainList = this.getEmailDomain(provider);
        if (explicit) {
            wildcardList = domainList;
        } else if ("uaa".equals(provider.getOriginKey())) {
            wildcardList = domainList == null ? Arrays.asList("*.*", "*.*.*", "*.*.*.*") : domainList;
        } else {
            List<String> list = wildcardList = domainList == null ? null : domainList;
        }
        if (wildcardList == null) {
            return false;
        }
        Set<Pattern> patterns = UaaStringUtils.constructWildcards(wildcardList);
        return UaaStringUtils.matches(patterns, domain);
    }
}

