/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;

public class UaaSessionCookieConfig
implements SessionCookieConfig,
ServletContextAware {
    protected static Log logger = LogFactory.getLog(UaaSessionCookieConfig.class);
    private String comment;
    private String domain;
    private int maxAge;
    private String path;
    private boolean httpOnly;
    private String name;
    private boolean secure;

    public void setServletContext(ServletContext servletContext) {
        logger.debug((Object)"Configuring session cookie.");
        try {
            SessionCookieConfig config = servletContext.getSessionCookieConfig();
            if (StringUtils.hasText((String)this.getComment())) {
                logger.debug((Object)String.format("Configuring session cookie - Comment: %s", this.getComment()));
                config.setComment(this.getComment());
            }
            if (StringUtils.hasText((String)this.getDomain())) {
                logger.debug((Object)String.format("Configuring session cookie - Domain: %s", this.getDomain()));
                config.setDomain(this.getDomain());
            }
            if (this.getMaxAge() > Integer.MIN_VALUE) {
                logger.debug((Object)String.format("Configuring session cookie - MaxAge: %s", this.getMaxAge()));
                config.setMaxAge(this.getMaxAge());
            }
            if (this.getPath() != null) {
                logger.debug((Object)String.format("Configuring session cookie - Path: %s", this.getPath()));
                config.setPath(this.getPath());
            }
            logger.debug((Object)String.format("Configuring session cookie - HttpOnly: %s", this.isHttpOnly()));
            config.setHttpOnly(this.isHttpOnly());
            logger.debug((Object)String.format("Configuring session cookie - Secure: %s", this.isSecure()));
            config.setSecure(this.isSecure());
            if (StringUtils.hasText((String)this.getName())) {
                logger.debug((Object)String.format("Configuring session cookie - Name: %s", this.getName()));
                config.setName(this.getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Ignoring session cookie config - unable to configure UAA session cookie", (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

