/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.client.ClientDetailsValidator;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationService;

public class IdentityZoneEndpointClientRegistrationService {
    private final ClientRegistrationService clientRegistrationService;
    private final ClientDetailsService clientDetailsService;
    private final ClientDetailsValidator clientDetailsValidator;
    private final ApprovalStore approvalStore;

    public IdentityZoneEndpointClientRegistrationService(ClientRegistrationService clientRegistrationService, ClientDetailsService clientDetailsService, ClientDetailsValidator clientDetailsValidator, ApprovalStore approvalStore) {
        this.clientRegistrationService = clientRegistrationService;
        this.clientDetailsService = clientDetailsService;
        this.clientDetailsValidator = clientDetailsValidator;
        this.approvalStore = approvalStore;
    }

    public ClientDetails createClient(ClientDetails clientDetails) {
        ClientDetails validated = this.clientDetailsValidator.validate(clientDetails, ClientDetailsValidator.Mode.CREATE);
        this.clientRegistrationService.addClientDetails(validated);
        return validated;
    }

    public ClientDetails deleteClient(String clientId) {
        ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
        this.clientDetailsValidator.validate(clientDetails, ClientDetailsValidator.Mode.DELETE);
        this.clientRegistrationService.removeClientDetails(clientId);
        this.approvalStore.revokeApprovals(String.format("client_id eq \"%s\"", clientId));
        return clientDetails;
    }
}

