/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDeserializer;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationSerializer;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@JsonSerialize(using=UaaAuthenticationSerializer.class)
@JsonDeserialize(using=UaaAuthenticationDeserializer.class)
public class UaaAuthentication
implements Authentication,
Serializable {
    private List<? extends GrantedAuthority> authorities;
    private Object credentials;
    private UaaPrincipal principal;
    private UaaAuthenticationDetails details;
    private boolean authenticated;
    private long authenticatedTime = -1L;
    private long expiresAt = -1L;
    private Set<String> externalGroups;
    private Map<String, List<String>> userAttributes;
    @JsonIgnore
    private SAMLMessageContext samlMessageContext;

    public UaaAuthentication(UaaPrincipal principal, List<? extends GrantedAuthority> authorities, UaaAuthenticationDetails details) {
        this(principal, null, authorities, details, true, System.currentTimeMillis());
    }

    public UaaAuthentication(UaaPrincipal principal, Object credentials, List<? extends GrantedAuthority> authorities, UaaAuthenticationDetails details, boolean authenticated, long authenticatedTime) {
        this(principal, credentials, authorities, details, authenticated, authenticatedTime, -1L);
    }

    public UaaAuthentication(UaaPrincipal principal, Object credentials, List<? extends GrantedAuthority> authorities, UaaAuthenticationDetails details, boolean authenticated, long authenticatedTime, long expiresAt) {
        if (principal == null || authorities == null) {
            throw new IllegalArgumentException("principal and authorities must not be null");
        }
        this.principal = principal;
        this.authorities = authorities;
        this.details = details;
        this.credentials = credentials;
        this.authenticated = authenticated;
        this.authenticatedTime = authenticatedTime <= 0L ? -1L : authenticatedTime;
        this.expiresAt = expiresAt <= 0L ? -1L : expiresAt;
    }

    public UaaAuthentication(UaaPrincipal uaaPrincipal, Object credentials, List<? extends GrantedAuthority> uaaAuthorityList, Set<String> externalGroups, Map<String, List<String>> userAttributes, UaaAuthenticationDetails details, boolean authenticated, long authenticatedTime, long expiresAt) {
        this(uaaPrincipal, credentials, uaaAuthorityList, details, authenticated, authenticatedTime, expiresAt);
        this.externalGroups = externalGroups;
        this.userAttributes = new HashMap<String, List<String>>(userAttributes);
    }

    public long getAuthenticatedTime() {
        return this.authenticatedTime;
    }

    public String getName() {
        return this.principal.getName();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getDetails() {
        return this.details;
    }

    public UaaPrincipal getPrincipal() {
        return this.principal;
    }

    public boolean isAuthenticated() {
        return this.authenticated && (this.expiresAt <= 0L || this.expiresAt > System.currentTimeMillis());
    }

    public void setAuthenticated(boolean isAuthenticated) {
        this.authenticated = isAuthenticated;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UaaAuthentication that = (UaaAuthentication)o;
        if (!this.authorities.equals(that.authorities)) {
            return false;
        }
        return this.principal.equals(that.principal);
    }

    public int hashCode() {
        int result = this.authorities.hashCode();
        result = 31 * result + this.principal.hashCode();
        return result;
    }

    public Set<String> getExternalGroups() {
        return this.externalGroups;
    }

    public void setExternalGroups(Set<String> externalGroups) {
        this.externalGroups = externalGroups;
    }

    public MultiValueMap<String, String> getUserAttributes() {
        return new LinkedMultiValueMap(this.userAttributes != null ? this.userAttributes : Collections.EMPTY_MAP);
    }

    public Map<String, List<String>> getUserAttributesAsMap() {
        return this.userAttributes != null ? new HashMap<String, List<String>>(this.userAttributes) : Collections.EMPTY_MAP;
    }

    public void setUserAttributes(MultiValueMap<String, String> userAttributes) {
        this.userAttributes = new HashMap<String, List<String>>();
        for (Map.Entry entry : userAttributes.entrySet()) {
            this.userAttributes.put((String)entry.getKey(), (List<String>)entry.getValue());
        }
    }

    @JsonIgnore
    public SAMLMessageContext getSamlMessageContext() {
        return this.samlMessageContext;
    }

    @JsonIgnore
    public void setSamlMessageContext(SAMLMessageContext samlMessageContext) {
        this.samlMessageContext = samlMessageContext;
    }
}

