/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import org.cloudfoundry.identity.uaa.authentication.AccountNotVerifiedException;
import org.cloudfoundry.identity.uaa.authentication.PasswordExpiredException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.util.MultiValueMap;

public class UaaExceptionTranslator
extends DefaultWebResponseExceptionTranslator {
    public ResponseEntity<OAuth2Exception> translate(Exception e) throws Exception {
        if (e instanceof AccountNotVerifiedException || e instanceof PasswordExpiredException) {
            return this.handleOAuth2Exception(new ForbiddenException(e.getMessage(), e));
        }
        return super.translate(e);
    }

    private ResponseEntity<OAuth2Exception> handleOAuth2Exception(OAuth2Exception e) throws IOException {
        int status = e.getHttpErrorCode();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cache-Control", "no-store");
        headers.set("Pragma", "no-cache");
        ResponseEntity response = new ResponseEntity((Object)e, (MultiValueMap)headers, HttpStatus.valueOf((int)status));
        return response;
    }

    private static class ForbiddenException
    extends OAuth2Exception {
        public ForbiddenException(String msg, Throwable t) {
            super(msg, t);
        }

        public String getOAuth2ErrorCode() {
            return "access_denied";
        }

        public int getHttpErrorCode() {
            return 403;
        }
    }
}

