/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.SAMLLogoutFilter;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class UaaSamlLogoutFilter
extends SAMLLogoutFilter {
    public UaaSamlLogoutFilter(LogoutSuccessHandler logoutSuccessHandler, LogoutHandler[] localHandler, LogoutHandler[] globalHandlers) {
        super(logoutSuccessHandler, localHandler, globalHandlers);
        this.setFilterProcessesUrl("/logout.do");
    }

    protected boolean isGlobalLogout(HttpServletRequest request, Authentication auth) {
        if (!(auth.getCredentials() instanceof SAMLCredential)) {
            return false;
        }
        try {
            SAMLCredential credential = (SAMLCredential)auth.getCredentials();
            request.setAttribute("localEntityId", (Object)credential.getLocalEntityID());
            request.setAttribute("peerEntityId", (Object)credential.getRemoteEntityID());
            SAMLMessageContext context = this.contextProvider.getLocalAndPeerEntity(request, null);
            IDPSSODescriptor idp = (IDPSSODescriptor)context.getPeerEntityRoleMetadata();
            List singleLogoutServices = idp.getSingleLogoutServices();
            return singleLogoutServices.size() != 0;
        }
        catch (MetadataProviderException e) {
            this.logger.debug((Object)"Error processing metadata", (Throwable)e);
            return false;
        }
    }
}

