/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.NewUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.user.DialableByPhone;
import org.cloudfoundry.identity.uaa.user.ExternallyIdentifiable;
import org.cloudfoundry.identity.uaa.user.Mailable;
import org.cloudfoundry.identity.uaa.user.Named;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.user.UaaUserPrototype;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ExternalLoginAuthenticationManager
implements AuthenticationManager,
ApplicationEventPublisherAware,
BeanNameAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationEventPublisher eventPublisher;
    private UaaUserDatabase userDatabase;
    private String name;
    private String origin = "unknown";

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    public UaaUserDatabase getUserDatabase() {
        return this.userDatabase;
    }

    public Authentication authenticate(Authentication request) throws AuthenticationException {
        UaaUser scimUser;
        UaaUser user = this.getUser(request);
        if (user == null) {
            return null;
        }
        try {
            scimUser = this.userDatabase.retrieveUserByName(user.getUsername(), this.getOrigin());
        }
        catch (UsernameNotFoundException e) {
            scimUser = this.userDatabase.retrieveUserByEmail(user.getEmail(), this.getOrigin());
        }
        if (scimUser != null) {
            user = scimUser;
        } else {
            this.publish(new NewUserAuthenticatedEvent(user));
            try {
                user = this.userDatabase.retrieveUserByName(user.getUsername(), this.getOrigin());
            }
            catch (UsernameNotFoundException ex) {
                throw new BadCredentialsException("Unable to register user in internal UAA store.");
            }
        }
        user = this.userAuthenticated(request, user);
        UaaAuthenticationDetails uaaAuthenticationDetails = null;
        uaaAuthenticationDetails = request.getDetails() instanceof UaaAuthenticationDetails ? (UaaAuthenticationDetails)request.getDetails() : UaaAuthenticationDetails.UNKNOWN;
        UaaAuthentication success = new UaaAuthentication(new UaaPrincipal(user), user.getAuthorities(), uaaAuthenticationDetails);
        if (request.getPrincipal() instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)request.getPrincipal();
            success.setUserAttributes(this.getUserAttributes(userDetails));
            success.setExternalGroups(new HashSet<String>(this.getExternalUserAuthorities(userDetails)));
        }
        this.publish(new UserAuthenticationSuccessEvent(user, (Authentication)success));
        return success;
    }

    protected MultiValueMap<String, String> getUserAttributes(UserDetails request) {
        return new LinkedMultiValueMap();
    }

    protected List<String> getExternalUserAuthorities(UserDetails request) {
        return new LinkedList<String>();
    }

    protected void publish(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected UaaUser userAuthenticated(Authentication request, UaaUser user) {
        return user;
    }

    protected UaaUser getUser(Authentication request) {
        UserDetails userDetails;
        if (request.getPrincipal() instanceof UserDetails) {
            userDetails = (UserDetails)request.getPrincipal();
        } else if (request instanceof UsernamePasswordAuthenticationToken) {
            String username = request.getPrincipal().toString();
            String password = request.getCredentials() != null ? request.getCredentials().toString() : "";
            userDetails = new User(username, password, true, true, true, true, UaaAuthority.USER_AUTHORITIES);
        } else {
            if (request.getPrincipal() == null) {
                this.logger.debug((Object)(this.getClass().getName() + "[" + this.name + "] cannot process null principal"));
                return null;
            }
            this.logger.debug((Object)(this.getClass().getName() + "[" + this.name + "] cannot process request of type: " + request.getClass().getName()));
            return null;
        }
        String name = userDetails.getUsername();
        String email = null;
        if (userDetails instanceof Mailable) {
            email = ((Mailable)userDetails).getEmailAddress();
            if (name == null) {
                name = email;
            }
        }
        if (email == null) {
            if (name != null) {
                email = name.contains("@") ? (name.split("@").length == 2 && !name.startsWith("@") && !name.endsWith("@") ? name : name.replaceAll("@", "") + "@user.from." + this.getOrigin() + ".cf") : name + "@user.from." + this.getOrigin() + ".cf";
            } else {
                throw new BadCredentialsException("Cannot determine username from credentials supplied");
            }
        }
        String givenName = null;
        String familyName = null;
        if (userDetails instanceof Named) {
            Named names = (Named)userDetails;
            givenName = names.getGivenName();
            familyName = names.getFamilyName();
        }
        String phoneNumber = userDetails instanceof DialableByPhone ? ((DialableByPhone)userDetails).getPhoneNumber() : null;
        String externalId = userDetails instanceof ExternallyIdentifiable ? ((ExternallyIdentifiable)userDetails).getExternalId() : name;
        UaaUserPrototype userPrototype = new UaaUserPrototype().withUsername(name).withPassword("").withEmail(email).withAuthorities(UaaAuthority.USER_AUTHORITIES).withGivenName(givenName).withFamilyName(familyName).withCreated(new Date()).withModified(new Date()).withOrigin(this.origin).withExternalId(externalId).withZoneId(IdentityZoneHolder.get().getId()).withPhoneNumber(phoneNumber);
        return new UaaUser(userPrototype);
    }

    public void setBeanName(String name) {
        this.name = name;
    }
}

