/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.codestore;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.util.Assert;

public class JdbcExpiringCodeStore
implements ExpiringCodeStore {
    public static final String tableName = "expiring_code_store";
    public static final String fields = "code, expiresat, data, intent";
    public static final String insert = "insert into expiring_code_store (code, expiresat, data, intent) values (?,?,?,?)";
    public static final String delete = "delete from expiring_code_store where code = ?";
    public static final String deleteIntent = "delete from expiring_code_store where intent = ?";
    public static final String deleteExpired = "delete from expiring_code_store where expiresat < ?";
    public static final String select = "select code, expiresat, data, intent from expiring_code_store where code = ?";
    public static final String SELECT_BY_EMAIL_AND_CLIENT_ID = "select code, expiresat, data, intent from expiring_code_store where data like '%%\"email\":\"%s\"%%' and data like '%%\"client_id\":\"%s\"%%' ORDER BY expiresat DESC LIMIT 1";
    private Log logger = LogFactory.getLog(this.getClass());
    private RandomValueStringGenerator generator = new RandomValueStringGenerator(6);
    private JdbcTemplate jdbcTemplate;
    private AtomicLong lastExpired = new AtomicLong();
    private long expirationInterval = 60000L;

    public long getExpirationInterval() {
        return this.expirationInterval;
    }

    public void setExpirationInterval(long expirationInterval) {
        this.expirationInterval = expirationInterval;
    }

    protected JdbcExpiringCodeStore() {
    }

    public JdbcExpiringCodeStore(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public ExpiringCode generateCode(String data, Timestamp expiresAt, String intent) {
        this.cleanExpiredEntries();
        if (data == null || expiresAt == null) {
            throw new NullPointerException();
        }
        if (expiresAt.getTime() < System.currentTimeMillis()) {
            throw new IllegalArgumentException();
        }
        for (int count = 0; count < 3; ++count) {
            String code = this.generator.generate();
            try {
                int update = this.jdbcTemplate.update(insert, new Object[]{code, expiresAt.getTime(), data, intent});
                if (update == 1) {
                    ExpiringCode expiringCode = new ExpiringCode(code, expiresAt, data, intent);
                    return expiringCode;
                }
                this.logger.warn((Object)("Unable to store expiring code:" + code));
                continue;
            }
            catch (DataIntegrityViolationException x) {
                if (count != 3) continue;
                throw x;
            }
        }
        return null;
    }

    @Override
    public ExpiringCode retrieveCode(String code) {
        this.cleanExpiredEntries();
        if (code == null) {
            throw new NullPointerException();
        }
        try {
            ExpiringCode expiringCode = (ExpiringCode)this.jdbcTemplate.queryForObject(select, (RowMapper)new JdbcExpiringCodeMapper(), new Object[]{code});
            try {
                if (expiringCode != null) {
                    this.jdbcTemplate.update(delete, new Object[]{code});
                }
                if (expiringCode.getExpiresAt().getTime() < System.currentTimeMillis()) {
                    expiringCode = null;
                    return expiringCode;
                }
            }
            finally {
                return expiringCode;
            }
        }
        catch (EmptyResultDataAccessException x) {
            return null;
        }
    }

    @Override
    public void setGenerator(RandomValueStringGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void expireByIntent(String intent) {
        Assert.hasText((String)intent);
        this.jdbcTemplate.update(deleteIntent, new Object[]{intent});
    }

    public int cleanExpiredEntries() {
        long lastCheck;
        long now = System.currentTimeMillis();
        if (now - (lastCheck = this.lastExpired.get()) > this.expirationInterval && this.lastExpired.compareAndSet(lastCheck, now)) {
            int count = this.jdbcTemplate.update(deleteExpired, new Object[]{now});
            this.logger.debug((Object)("Expiring code sweeper complete, deleted " + count + " entries."));
            return count;
        }
        return 0;
    }

    protected static class JdbcExpiringCodeMapper
    implements RowMapper<ExpiringCode> {
        protected JdbcExpiringCodeMapper() {
        }

        public ExpiringCode mapRow(ResultSet rs, int rowNum) throws SQLException {
            int pos = 1;
            String code = rs.getString(pos++);
            Timestamp expiresAt = new Timestamp(rs.getLong(pos++));
            String data = rs.getString(pos++);
            String intent = rs.getString(pos++);
            return new ExpiringCode(code, expiresAt, data, intent);
        }
    }
}

