/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.ZoneAwareMetadataManager;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.cloudfoundry.identity.uaa.zone.event.IdentityProviderModifiedEvent;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.context.ApplicationListener;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;

public class ProviderChangedListener
implements ApplicationListener<IdentityProviderModifiedEvent> {
    private static final Log logger = LogFactory.getLog(ProviderChangedListener.class);
    private ZoneAwareMetadataManager metadataManager = null;
    private final SamlIdentityProviderConfigurator configurator;
    private final IdentityZoneProvisioning zoneProvisioning;

    public ProviderChangedListener(SamlIdentityProviderConfigurator configurator, IdentityZoneProvisioning zoneProvisioning) {
        this.configurator = configurator;
        this.zoneProvisioning = zoneProvisioning;
    }

    public void onApplicationEvent(IdentityProviderModifiedEvent event) {
        if (this.metadataManager == null) {
            return;
        }
        IdentityProvider eventProvider = (IdentityProvider)event.getSource();
        if ("saml".equals(eventProvider.getType())) {
            IdentityProvider provider = eventProvider;
            IdentityZone zone = this.zoneProvisioning.retrieve(provider.getIdentityZoneId());
            ZoneAwareMetadataManager.ExtensionMetadataManager manager = this.metadataManager.getManager(zone);
            SamlIdentityProviderDefinition definition = (SamlIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), SamlIdentityProviderDefinition.class);
            try {
                if (provider.isActive()) {
                    ExtendedMetadataDelegate[] delegates = this.configurator.addSamlIdentityProviderDefinition(definition);
                    if (delegates[1] != null) {
                        manager.removeMetadataProvider((MetadataProvider)delegates[1]);
                    }
                    manager.addMetadataProvider((MetadataProvider)delegates[0]);
                } else {
                    ExtendedMetadataDelegate delegate = this.configurator.removeIdentityProviderDefinition(definition);
                    if (delegate != null) {
                        manager.removeMetadataProvider((MetadataProvider)delegate);
                    }
                }
                for (MetadataProvider idp : manager.getProviders()) {
                    idp.getMetadata();
                }
                manager.refreshMetadata();
                this.metadataManager.getManager(zone).refreshMetadata();
            }
            catch (MetadataProviderException e) {
                logger.error((Object)("Unable to add new IDP provider:" + definition), (Throwable)e);
            }
        }
    }

    public void setMetadataManager(ZoneAwareMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }
}

