/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.scim.InternalUserManagementDisabledException;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.cloudfoundry.identity.uaa.web.ExceptionReportHttpMessageConverter;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public class DisableUserManagementSecurityFilter
extends OncePerRequestFilter {
    private final IdentityProviderProvisioning identityProviderProvisioning;
    private static String regex = "";
    private Pattern pattern = Pattern.compile(regex);
    private List<String> methods = Arrays.asList("GET", "POST", "PUT", "DELETE");

    public DisableUserManagementSecurityFilter(IdentityProviderProvisioning identityProviderProvisioning) {
        this.identityProviderProvisioning = identityProviderProvisioning;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.matches(request)) {
            IdentityProvider idp = this.identityProviderProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
            boolean isDisableInternalUserManagement = false;
            UaaIdentityProviderDefinition config = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)idp.getConfig(), UaaIdentityProviderDefinition.class);
            if (config != null) {
                isDisableInternalUserManagement = config.isDisableInternalUserManagement();
            }
            if (isDisableInternalUserManagement) {
                ExceptionReportHttpMessageConverter converter = new ExceptionReportHttpMessageConverter();
                response.setStatus(403);
                converter.write(new ExceptionReport(new InternalUserManagementDisabledException("Internal User Creation is currently disabled. External User Store is in use.")), MediaType.APPLICATION_JSON, (HttpOutputMessage)new ServletServerHttpResponse(response));
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean matches(HttpServletRequest request) {
        return this.pattern.matcher(this.getUri(request)).matches() && this.methods.contains(request.getMethod());
    }

    private String getUri(HttpServletRequest request) {
        if (request.getContextPath() != null && request.getContextPath().length() > 0) {
            return request.getServletPath();
        }
        return request.getRequestURI();
    }

    static {
        regex = "^/Users.*";
        regex = regex + "|^/create_account";
        regex = regex + "|^/create_account.do";
        regex = regex + "|^/accounts/email_sent";
        regex = regex + "|^/verify_user";
        regex = regex + "|^/change_email";
        regex = regex + "|^/change_email.do";
        regex = regex + "|^/verify_email";
        regex = regex + "|^/change_password";
        regex = regex + "|^/change_password.do";
        regex = regex + "|^/forgot_password";
        regex = regex + "|^/forgot_password.do";
        regex = regex + "|^/email_sent";
        regex = regex + "|^/reset_password";
        regex = regex + "|^/reset_password.do";
    }
}

