/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class ScimExternalGroupBootstrap
implements InitializingBean {
    private List<Map<String, ExternalGroupStruct>> externalGroupMap;
    private Set<String> externalGroupList;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupExternalMembershipManager externalMembershipManager;
    private static final String GROUP_BY_NAME_FILTER = "displayName eq \"%s\"";
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean addNonExistingGroups = false;

    protected ScimGroupProvisioning getScimGroupProvisioning() {
        return this.scimGroupProvisioning;
    }

    public boolean isAddNonExistingGroups() {
        return this.addNonExistingGroups;
    }

    public void setAddNonExistingGroups(boolean addNonExistingGroups) {
        this.addNonExistingGroups = addNonExistingGroups;
    }

    public ScimExternalGroupBootstrap(ScimGroupProvisioning scimGroupProvisioning, ScimGroupExternalMembershipManager externalMembershipManager) {
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.externalMembershipManager = externalMembershipManager;
        this.externalGroupMap = new ArrayList<Map<String, ExternalGroupStruct>>();
    }

    public void setExternalGroupMap(Set<String> externalGroupMaps) {
        this.externalGroupList = externalGroupMaps;
    }

    protected ScimGroup addGroup(String groupName) {
        ScimGroup group = new ScimGroup(null, groupName, IdentityZoneHolder.get().getId());
        try {
            return this.getScimGroupProvisioning().create(group);
        }
        catch (ScimResourceAlreadyExistsException x) {
            List groups = this.getScimGroupProvisioning().query(String.format(GROUP_BY_NAME_FILTER, groupName));
            if (groups != null && groups.size() > 0) {
                return (ScimGroup)groups.get(0);
            }
            throw new RuntimeException("Unable to create or return group with name:" + groupName);
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (String string : this.externalGroupList) {
            String[] fields = string.split("\\|");
            if (fields.length < 2) continue;
            String groupName = fields[0];
            List groups = this.getScimGroupProvisioning().query(String.format(GROUP_BY_NAME_FILTER, groupName));
            if (groups == null || groups.size() == 0 && this.isAddNonExistingGroups()) {
                groups = new ArrayList();
                groups.add(this.addGroup(groupName));
            }
            String origin = "ldap";
            if (null == groups || groups.size() != 1) continue;
            String groupId = ((ScimGroup)groups.get(0)).getId();
            if (!StringUtils.hasText((String)fields[1])) continue;
            String[] externalGroups = fields[1].split(" ");
            if (fields.length >= 3 && StringUtils.hasText((String)fields[2])) {
                origin = fields[2];
            }
            if (null == externalGroups || externalGroups.length <= 0) continue;
            for (String externalGroup : externalGroups) {
                if (!StringUtils.hasLength((String)externalGroup.trim())) continue;
                ExternalGroupStruct externalGroupStruct = new ExternalGroupStruct(externalGroup.trim(), origin);
                this.externalGroupMap.add(Collections.singletonMap(groupId, externalGroupStruct));
            }
        }
        for (Map map : this.externalGroupMap) {
            Map.Entry entry = map.entrySet().iterator().next();
            this.addGroupMap((String)entry.getKey(), ((ExternalGroupStruct)entry.getValue()).externalGroup, ((ExternalGroupStruct)entry.getValue()).origin);
        }
    }

    private void addGroupMap(String groupId, String externalGroup, String origin) {
        ScimGroupExternalMember externalGroupMapping = this.externalMembershipManager.mapExternalGroup(groupId, externalGroup, origin);
        this.logger.debug((Object)("adding external group mapping: " + externalGroupMapping));
    }

    private static class ExternalGroupStruct {
        public final String externalGroup;
        public final String origin;

        public ExternalGroupStruct(String externalGroup, String origin) {
            this.externalGroup = externalGroup;
            this.origin = origin;
        }
    }
}

