/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.resources.ResourceMonitor;
import org.cloudfoundry.identity.uaa.resources.SearchResults;
import org.cloudfoundry.identity.uaa.resources.SearchResultsFactory;
import org.cloudfoundry.identity.uaa.resources.SimpleAttributeNameMapper;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.endpoints.VerificationResponse;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceConflictException;
import org.cloudfoundry.identity.uaa.scim.exception.UserAlreadyVerifiedException;
import org.cloudfoundry.identity.uaa.scim.util.ScimUtils;
import org.cloudfoundry.identity.uaa.scim.validate.PasswordValidator;
import org.cloudfoundry.identity.uaa.util.UaaPagingUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.web.ConvertingExceptionView;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;

@Controller
@ManagedResource
public class ScimUserEndpoints
implements InitializingBean {
    private static final String USER_APPROVALS_FILTER_TEMPLATE = "user_id eq \"%s\"";
    private static Log logger = LogFactory.getLog(ScimUserEndpoints.class);
    public static final String E_TAG = "ETag";
    private ScimUserProvisioning dao;
    private ResourceMonitor<ScimUser> scimUserResourceMonitor;
    private ScimGroupMembershipManager membershipManager;
    private ApprovalStore approvalStore;
    private static final Random passwordGenerator = new SecureRandom();
    private final Map<String, AtomicInteger> errorCounts = new ConcurrentHashMap<String, AtomicInteger>();
    private AtomicInteger scimUpdates = new AtomicInteger();
    private AtomicInteger scimDeletes = new AtomicInteger();
    private Map<Class<? extends Exception>, HttpStatus> statuses = new HashMap<Class<? extends Exception>, HttpStatus>();
    private HttpMessageConverter<?>[] messageConverters = new RestTemplate().getMessageConverters().toArray(new HttpMessageConverter[0]);
    private PasswordValidator passwordValidator;
    private ExpiringCodeStore codeStore;

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setStatuses(Map<Class<? extends Exception>, HttpStatus> statuses) {
        this.statuses = statuses;
    }

    private static String generatePassword() {
        byte[] bytes = new byte[16];
        passwordGenerator.nextBytes(bytes);
        return new String(Hex.encode((byte[])bytes));
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Total Users")
    public int getTotalUsers() {
        return this.scimUserResourceMonitor.getTotalCount();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="User Account Update Count (Since Startup)")
    public int getUserUpdates() {
        return this.scimUpdates.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="User Account Delete Count (Since Startup)")
    public int getUserDeletes() {
        return this.scimDeletes.get();
    }

    @ManagedMetric(displayName="Error Counts")
    public Map<String, AtomicInteger> getErrorCounts() {
        return this.errorCounts;
    }

    @RequestMapping(value={"/Users/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ScimUser getUser(@PathVariable String userId, HttpServletResponse httpServletResponse) {
        ScimUser scimUser = this.syncApprovals(this.syncGroups((ScimUser)this.dao.retrieve(userId)));
        this.addETagHeader(httpServletResponse, scimUser);
        return scimUser;
    }

    @RequestMapping(value={"/Users"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ScimUser createUser(@RequestBody ScimUser user, HttpServletResponse httpServletResponse) {
        if (user.getPassword() == null) {
            user.setPassword(ScimUserEndpoints.generatePassword());
        } else {
            this.passwordValidator.validate(user.getPassword());
        }
        ScimUser scimUser = this.dao.createUser(user, user.getPassword());
        if (user.getApprovals() != null) {
            for (Approval approval : user.getApprovals()) {
                approval.setUserId(scimUser.getId());
                this.approvalStore.addApproval(approval);
            }
        }
        scimUser = this.syncApprovals(this.syncGroups(scimUser));
        this.addETagHeader(httpServletResponse, scimUser);
        return scimUser;
    }

    @RequestMapping(value={"/Users/{userId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ScimUser updateUser(@RequestBody ScimUser user, @PathVariable String userId, @RequestHeader(value="If-Match", required=false, defaultValue="NaN") String etag, HttpServletResponse httpServletResponse) {
        if (etag.equals("NaN")) {
            throw new ScimException("Missing If-Match for PUT", HttpStatus.BAD_REQUEST);
        }
        int version = this.getVersion(userId, etag);
        user.setVersion(version);
        try {
            ScimUser updated = this.dao.update(userId, user);
            this.scimUpdates.incrementAndGet();
            ScimUser scimUser = this.syncApprovals(this.syncGroups(updated));
            this.addETagHeader(httpServletResponse, scimUser);
            return scimUser;
        }
        catch (OptimisticLockingFailureException e) {
            throw new ScimResourceConflictException(e.getMessage());
        }
    }

    @RequestMapping(value={"/Users/{userId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ScimUser deleteUser(@PathVariable String userId, @RequestHeader(value="If-Match", required=false) String etag, HttpServletResponse httpServletResponse) {
        int version = etag == null ? -1 : this.getVersion(userId, etag);
        ScimUser user = this.getUser(userId, httpServletResponse);
        this.membershipManager.removeMembersByMemberId(userId);
        this.dao.delete(userId, version);
        this.scimDeletes.incrementAndGet();
        return user;
    }

    @RequestMapping(value={"/Users/{userId}/verify-link"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<VerificationResponse> getUserVerificationLink(@PathVariable String userId, @RequestParam(value="client_id", required=false) String clientId, @RequestParam(value="redirect_uri") String redirectUri) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)authentication;
            if (clientId == null) {
                clientId = oAuth2Authentication.getOAuth2Request().getClientId();
            }
        }
        VerificationResponse responseBody = new VerificationResponse();
        ScimUser user = (ScimUser)this.dao.retrieve(userId);
        if (user.isVerified()) {
            throw new UserAlreadyVerifiedException();
        }
        ExpiringCode expiringCode = ScimUtils.getExpiringCode(this.codeStore, userId, user.getPrimaryEmail(), clientId, redirectUri);
        responseBody.setVerifyLink(ScimUtils.getVerificationURL(expiringCode));
        return new ResponseEntity((Object)responseBody, HttpStatus.OK);
    }

    @RequestMapping(value={"/Users/{userId}/verify"}, method={RequestMethod.GET})
    @ResponseBody
    public ScimUser verifyUser(@PathVariable String userId, @RequestHeader(value="If-Match", required=false) String etag, HttpServletResponse httpServletResponse) {
        int version = etag == null ? -1 : this.getVersion(userId, etag);
        ScimUser user = this.dao.verifyUser(userId, version);
        this.scimUpdates.incrementAndGet();
        this.addETagHeader(httpServletResponse, user);
        return user;
    }

    private int getVersion(String userId, String etag) {
        String value = etag.trim();
        while (value.startsWith("\"")) {
            value = value.substring(1);
        }
        while (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.equals("*")) {
            return ((ScimUser)this.dao.retrieve(userId)).getVersion();
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ScimException("Invalid version match header (should be a version number): " + etag, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/Users"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResults<?> findUsers(@RequestParam(value="attributes", required=false) String attributesCommaSeparated, @RequestParam(required=false, defaultValue="id pr") String filter, @RequestParam(required=false, defaultValue="created") String sortBy, @RequestParam(required=false, defaultValue="ascending") String sortOrder, @RequestParam(required=false, defaultValue="1") int startIndex, @RequestParam(required=false, defaultValue="100") int count) {
        List result;
        if (startIndex < 1) {
            startIndex = 1;
        }
        ArrayList<ScimUser> input = new ArrayList<ScimUser>();
        try {
            result = this.dao.query(filter, sortBy, sortOrder.equals("ascending"));
            for (ScimUser user : UaaPagingUtils.subList(result, startIndex, count)) {
                if (attributesCommaSeparated == null || attributesCommaSeparated.matches("(?i)groups") || attributesCommaSeparated.isEmpty()) {
                    this.syncGroups(user);
                }
                if (attributesCommaSeparated == null || attributesCommaSeparated.matches("(?i)approvals") || attributesCommaSeparated.isEmpty()) {
                    this.syncApprovals(user);
                }
                input.add(user);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ScimException("Invalid filter expression: [" + filter + "]", HttpStatus.BAD_REQUEST);
        }
        if (!StringUtils.hasLength((String)attributesCommaSeparated)) {
            return new SearchResults(Arrays.asList(ScimCore.SCHEMAS), input, startIndex, count, result.size());
        }
        SimpleAttributeNameMapper mapper = new SimpleAttributeNameMapper(Collections.singletonMap("emails\\.(.*)", "emails.![$1]"));
        String[] attributes = attributesCommaSeparated.split(",");
        try {
            return SearchResultsFactory.buildSearchResultFrom(input, startIndex, count, result.size(), attributes, mapper, Arrays.asList(ScimCore.SCHEMAS));
        }
        catch (SpelParseException e) {
            throw new ScimException("Invalid attributes: [" + attributesCommaSeparated + "]", HttpStatus.BAD_REQUEST);
        }
        catch (SpelEvaluationException e) {
            throw new ScimException("Invalid attributes: [" + attributesCommaSeparated + "]", HttpStatus.BAD_REQUEST);
        }
    }

    private ScimUser syncGroups(ScimUser user) {
        if (user == null) {
            return user;
        }
        Set<ScimGroup> directGroups = this.membershipManager.getGroupsWithMember(user.getId(), false);
        Set<ScimGroup> indirectGroups = this.membershipManager.getGroupsWithMember(user.getId(), true);
        indirectGroups.removeAll(directGroups);
        HashSet<ScimUser.Group> groups = new HashSet<ScimUser.Group>();
        for (ScimGroup group : directGroups) {
            groups.add(new ScimUser.Group(group.getId(), group.getDisplayName(), ScimUser.Group.Type.DIRECT));
        }
        for (ScimGroup group : indirectGroups) {
            groups.add(new ScimUser.Group(group.getId(), group.getDisplayName(), ScimUser.Group.Type.INDIRECT));
        }
        user.setGroups(groups);
        return user;
    }

    private ScimUser syncApprovals(ScimUser user) {
        if (user == null || this.approvalStore == null) {
            return user;
        }
        HashSet<Approval> approvals = new HashSet<Approval>(this.approvalStore.getApprovals(String.format(USER_APPROVALS_FILTER_TEMPLATE, user.getId())));
        HashSet<Approval> active = new HashSet<Approval>(approvals);
        for (Approval approval : approvals) {
            if (approval.isCurrentlyActive()) continue;
            active.remove(approval);
        }
        user.setApprovals(active);
        return user;
    }

    @ExceptionHandler
    public View handleException(Exception t, HttpServletRequest request) throws ScimException {
        logger.error((Object)"Unhandled exception in SCIM user endpoints.", (Throwable)t);
        ScimException e = new ScimException("Unexpected error", t, HttpStatus.INTERNAL_SERVER_ERROR);
        if (t instanceof ScimException) {
            e = (ScimException)t;
        } else {
            Class<?> clazz = t.getClass();
            for (Class<? extends Exception> key : this.statuses.keySet()) {
                if (!key.isAssignableFrom(clazz)) continue;
                e = new ScimException(t.getMessage(), t, this.statuses.get(key));
                break;
            }
        }
        this.incrementErrorCounts(e);
        boolean trace = request.getParameter("trace") != null && !request.getParameter("trace").equals("false");
        return new ConvertingExceptionView((ResponseEntity<? extends ExceptionReport>)new ResponseEntity((Object)new ExceptionReport(e, trace, e.getExtraInfo()), e.getStatus()), this.messageConverters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementErrorCounts(ScimException e) {
        String series = UaaStringUtils.getErrorName(e);
        AtomicInteger value = this.errorCounts.get(series);
        if (value == null) {
            Map<String, AtomicInteger> map = this.errorCounts;
            synchronized (map) {
                value = this.errorCounts.get(series);
                if (value == null) {
                    value = new AtomicInteger();
                    this.errorCounts.put(series, value);
                }
            }
        }
        value.incrementAndGet();
    }

    public void setScimUserProvisioning(ScimUserProvisioning dao) {
        this.dao = dao;
    }

    public void setScimGroupMembershipManager(ScimGroupMembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public void setApprovalStore(ApprovalStore approvalStore) {
        this.approvalStore = approvalStore;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dao, (String)"ScimUserProvisioning must be set");
        Assert.notNull((Object)this.membershipManager, (String)"ScimGroupMembershipManager must be set");
        Assert.notNull((Object)this.approvalStore, (String)"ApprovalStore must be set");
    }

    private void addETagHeader(HttpServletResponse httpServletResponse, ScimUser scimUser) {
        httpServletResponse.setHeader(E_TAG, "\"" + scimUser.getVersion() + "\"");
    }

    public void setScimUserResourceMonitor(ResourceMonitor<ScimUser> scimUserResourceMonitor) {
        this.scimUserResourceMonitor = scimUserResourceMonitor;
    }

    public void setPasswordValidator(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    public void setCodeStore(ExpiringCodeStore codeStore) {
        this.codeStore = codeStore;
    }
}

