/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security.web;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class CorsFilter
extends OncePerRequestFilter {
    static final Log logger = LogFactory.getLog(CorsFilter.class);
    public static final String X_REQUESTED_WITH = "X-Requested-With";
    public static final int ACCESS_CONTROL_MAX_AGE_DEFAULT = 1728000;
    public static final String WILDCARD = "*";
    private CorsConfiguration xhrConfiguration = new CorsConfiguration();
    private CorsConfiguration defaultConfiguration = new CorsConfiguration();

    public CorsFilter() {
        this.xhrConfiguration.setAllowedMethods(Arrays.asList(HttpMethod.GET.toString(), HttpMethod.OPTIONS.toString()));
        this.defaultConfiguration.setAllowedMethods(Arrays.asList(HttpMethod.GET.toString(), HttpMethod.OPTIONS.toString(), HttpMethod.POST.toString(), HttpMethod.PUT.toString(), HttpMethod.DELETE.toString()));
        this.xhrConfiguration.setAllowedHeaders(Arrays.asList("Accept", "Accept-Language", "Content-Type", "Content-Language", "Authorization", X_REQUESTED_WITH));
        this.defaultConfiguration.setAllowedHeaders(Arrays.asList("Accept", "Accept-Language", "Content-Type", "Content-Language", "Authorization"));
        this.xhrConfiguration.setAllowedCredentials(true);
        this.defaultConfiguration.setAllowedCredentials(false);
    }

    @PostConstruct
    public void initialize() {
        for (CorsConfiguration configuration : Arrays.asList(this.xhrConfiguration, this.defaultConfiguration)) {
            String type = configuration == this.xhrConfiguration ? "xhr" : "default";
            configuration.getAllowedUriPatterns().clear();
            configuration.getAllowedOriginPatterns().clear();
            if (configuration.getAllowedUris() != null) {
                for (String allowedUri : configuration.getAllowedUris()) {
                    try {
                        configuration.getAllowedUriPatterns().add(Pattern.compile(allowedUri));
                        logger.debug((Object)String.format("URI '%s' is allowed for a %s CORS requests.", allowedUri, type));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        logger.error((Object)("Invalid regular expression pattern in cors." + type + ".allowed.uris: " + allowedUri), (Throwable)patternSyntaxException);
                    }
                }
            }
            if (configuration.getAllowedOrigins() == null) continue;
            for (String allowedOrigin : configuration.getAllowedOrigins()) {
                try {
                    configuration.getAllowedOriginPatterns().add(Pattern.compile(allowedOrigin));
                    logger.debug((Object)String.format("Origin '%s' is allowed for a %s CORS requests.", allowedOrigin, type));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    logger.error((Object)("Invalid regular expression pattern in cors." + type + ".allowed.origins: " + allowedOrigin), (Throwable)patternSyntaxException);
                }
            }
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.isCrossOriginRequest(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CORS Processing request: " + this.getRequestInfo(request)));
        }
        if (this.isXhrRequest(request)) {
            this.handleRequest(request, response, filterChain, this.getXhrConfiguration());
        } else {
            this.handleRequest(request, response, filterChain, this.getDefaultConfiguration());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CORS processing completed for: " + this.getRequestInfo(request) + " Status:" + response.getStatus()));
        }
    }

    protected boolean handleRequest(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, CorsConfiguration configuration) throws IOException, ServletException {
        URI originURI;
        boolean isPreflightRequest = HttpMethod.OPTIONS.toString().equals(request.getMethod());
        String method = request.getMethod();
        if (!isPreflightRequest && !this.isAllowedMethod(method, configuration)) {
            logger.debug((Object)String.format("Request with invalid method was rejected: %s", method));
            response.sendError(HttpStatus.METHOD_NOT_ALLOWED.value(), "Illegal method.");
            return true;
        }
        String origin = request.getHeader("Origin");
        try {
            originURI = new URI(origin);
        }
        catch (URISyntaxException e) {
            logger.debug((Object)String.format("Request with invalid origin was rejected: %s", origin));
            response.sendError(HttpStatus.FORBIDDEN.value(), "Invalid origin");
            return true;
        }
        if (!this.isAllowedOrigin(origin, configuration)) {
            logger.debug((Object)String.format("Request with origin: %s was rejected because it didn't match allowed origins", origin));
            response.sendError(HttpStatus.FORBIDDEN.value(), "Illegal origin");
            return true;
        }
        String requestUri = request.getRequestURI();
        if (!this.isAllowedRequestUri(requestUri, configuration)) {
            logger.debug((Object)String.format("Request with URI: %s was rejected because it didn't match allowed URIs", requestUri));
            response.sendError(HttpStatus.FORBIDDEN.value(), "Illegal request URI");
            return true;
        }
        if (configuration.isAllowedCredentials()) {
            response.addHeader("Access-Control-Allow-Origin", originURI.toString());
        } else {
            response.addHeader("Access-Control-Allow-Origin", WILDCARD);
        }
        if (isPreflightRequest) {
            logger.debug((Object)String.format("Request is a pre-flight request", new Object[0]));
            this.buildCorsPreFlightResponse(request, response, configuration);
        } else {
            logger.debug((Object)String.format("Request cross origin request has passed validation.", new Object[0]));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        return false;
    }

    protected boolean isXhrRequest(HttpServletRequest request) {
        if (StringUtils.hasText((String)request.getHeader(X_REQUESTED_WITH))) {
            return true;
        }
        String accessControlRequestHeaders = request.getHeader("Access-Control-Request-Headers");
        return StringUtils.hasText((String)accessControlRequestHeaders) && this.containsHeader(accessControlRequestHeaders, X_REQUESTED_WITH);
    }

    protected boolean isCrossOriginRequest(HttpServletRequest request) {
        return StringUtils.hasText((String)request.getHeader("Origin"));
    }

    protected String buildCommaDelimitedString(List<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String s : list) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    protected List<String> splitCommaDelimitedString(String s) {
        String[] list = s.replace(" ", "").split(",");
        if (list == null || list.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(list);
    }

    protected void buildCorsPreFlightResponse(HttpServletRequest request, HttpServletResponse response, CorsConfiguration configuration) throws IOException {
        String accessControlRequestMethod = request.getHeader("Access-Control-Request-Method");
        if (null == accessControlRequestMethod) {
            response.sendError(HttpStatus.BAD_REQUEST.value(), "Access-Control-Request-Method header is missing");
            return;
        }
        if (!this.isAllowedMethod(accessControlRequestMethod, configuration)) {
            response.sendError(HttpStatus.METHOD_NOT_ALLOWED.value(), "Illegal method requested");
            return;
        }
        response.addHeader("Access-Control-Allow-Methods", this.buildCommaDelimitedString(configuration.getAllowedMethods()));
        String accessControlRequestHeaders = request.getHeader("Access-Control-Request-Headers");
        if (null == accessControlRequestHeaders) {
            response.sendError(HttpStatus.BAD_REQUEST.value(), "Missing Access-Control-Request-Headers header.");
            return;
        }
        if (!this.headersAllowed(accessControlRequestHeaders, configuration)) {
            response.sendError(HttpStatus.FORBIDDEN.value(), "Illegal header requested");
            return;
        }
        response.addHeader("Access-Control-Allow-Headers", accessControlRequestHeaders);
        response.addHeader("Access-Control-Max-Age", String.valueOf(configuration.getMaxAge()));
    }

    protected boolean containsHeader(String accessControlRequestHeaders, String header) {
        List<String> headers = this.splitCommaDelimitedString(accessControlRequestHeaders);
        return UaaStringUtils.containsIgnoreCase(headers, header);
    }

    protected boolean headersAllowed(String accessControlRequestHeaders, CorsConfiguration configuration) {
        List<String> headers = this.splitCommaDelimitedString(accessControlRequestHeaders);
        for (String header : headers) {
            if (UaaStringUtils.containsIgnoreCase(configuration.getAllowedHeaders(), header)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAllowedMethod(String method, CorsConfiguration configuration) {
        return UaaStringUtils.containsIgnoreCase(configuration.getAllowedMethods(), method);
    }

    protected boolean isAllowedRequestUri(String uri, CorsConfiguration configuration) {
        if (StringUtils.isEmpty((Object)uri)) {
            return false;
        }
        for (Pattern pattern : configuration.getAllowedUriPatterns()) {
            if (!pattern.matcher(uri).find()) continue;
            return true;
        }
        logger.debug((Object)String.format("The '%s' URI does not allow CORS requests.", uri));
        return false;
    }

    protected boolean isAllowedOrigin(String origin, CorsConfiguration configuration) {
        for (Pattern pattern : configuration.getAllowedOriginPatterns()) {
            if (!pattern.matcher(origin).find()) continue;
            return true;
        }
        logger.debug((Object)String.format("The '%s' origin is not allowed to make CORS requests.", origin));
        return false;
    }

    public String getRequestInfo(HttpServletRequest request) {
        return String.format("URI: %s; Scheme: %s; Host: %s; Port: %s; Origin: %s; Method: %s", request.getRequestURI(), request.getScheme(), request.getServerName(), request.getServerPort(), request.getHeader("Origin"), request.getMethod());
    }

    public void setCorsXhrAllowedUris(List<String> corsXhrAllowedUris) {
        this.xhrConfiguration.setAllowedUris(corsXhrAllowedUris);
    }

    public void setCorsXhrAllowedOrigins(List<String> corsXhrAllowedOrigins) {
        this.xhrConfiguration.setAllowedOrigins(corsXhrAllowedOrigins);
    }

    public void setCorsXhrAllowedHeaders(List<String> allowedHeaders) {
        this.xhrConfiguration.setAllowedHeaders(new ArrayList<String>(allowedHeaders));
    }

    public void setCorsXhrAllowedCredentials(boolean allowedCredentials) {
        this.xhrConfiguration.setAllowedCredentials(allowedCredentials);
    }

    public void setCorsXhrAllowedMethods(List<String> corsXhrAllowedMethods) {
        this.xhrConfiguration.setAllowedMethods(new ArrayList<String>(corsXhrAllowedMethods));
    }

    public void setCorsXhrMaxAge(int age) {
        this.xhrConfiguration.setMaxAge(age);
    }

    public void setCorsAllowedUris(List<String> corsAllowedUris) {
        this.defaultConfiguration.setAllowedUris(corsAllowedUris);
    }

    public void setCorsAllowedOrigins(List<String> corsAllowedOrigins) {
        this.defaultConfiguration.setAllowedOrigins(corsAllowedOrigins);
    }

    public void setCorsAllowedHeaders(List<String> allowedHeaders) {
        this.defaultConfiguration.setAllowedHeaders(new ArrayList<String>(allowedHeaders));
    }

    public void setCorsAllowedCredentials(boolean allowedCredentials) {
        this.defaultConfiguration.setAllowedCredentials(allowedCredentials);
    }

    public void setCorsAllowedMethods(List<String> corsXhrAllowedMethods) {
        this.defaultConfiguration.setAllowedMethods(new ArrayList<String>(corsXhrAllowedMethods));
    }

    public void setCorsMaxAge(int age) {
        this.defaultConfiguration.setMaxAge(age);
    }

    public CorsConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public CorsConfiguration getXhrConfiguration() {
        return this.xhrConfiguration;
    }

    public static class CorsConfiguration {
        private List<String> allowedOrigins = Arrays.asList(".*");
        private final List<Pattern> allowedOriginPatterns = new ArrayList<Pattern>();
        private List<String> allowedUris = Arrays.asList(".*");
        private final List<Pattern> allowedUriPatterns = new ArrayList<Pattern>();
        private List<String> allowedHeaders = Arrays.asList("Accept", "Authorization", "Content-Type");
        private List<String> allowedMethods = Arrays.asList(HttpMethod.GET.toString());
        private boolean allowedCredentials = false;
        private int maxAge = 1728000;

        public boolean isAllowedCredentials() {
            return this.allowedCredentials;
        }

        public void setAllowedCredentials(boolean allowedCredentials) {
            this.allowedCredentials = allowedCredentials;
        }

        public List<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        public void setAllowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        public List<String> getAllowedMethods() {
            return this.allowedMethods;
        }

        public void setAllowedMethods(List<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public List<Pattern> getAllowedOriginPatterns() {
            return this.allowedOriginPatterns;
        }

        public List<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        public void setAllowedOrigins(List<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public List<Pattern> getAllowedUriPatterns() {
            return this.allowedUriPatterns;
        }

        public List<String> getAllowedUris() {
            return this.allowedUris;
        }

        public void setAllowedUris(List<String> allowedUris) {
            this.allowedUris = allowedUris;
        }

        public int getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(int maxAge) {
            this.maxAge = maxAge;
        }
    }
}

