/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.impl.config.NestedMapPropertySource;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class UaaMapUtils {
    public static Map<String, Object> flatten(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map == null || map.isEmpty()) {
            return result;
        }
        NestedMapPropertySource properties = new NestedMapPropertySource("map", map);
        for (String property : properties.getPropertyNames()) {
            if (properties.getProperty(property) == null) continue;
            result.put(property, properties.getProperty(property));
        }
        return result;
    }

    public static Map<String, Object> getPropertiesStartingWith(ConfigurableEnvironment aEnv, String aKeyPrefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> map = UaaMapUtils.getAllProperties(aEnv);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(aKeyPrefix)) continue;
            result.put(key, entry.getValue());
        }
        return result;
    }

    public static Map<String, Object> getAllProperties(ConfigurableEnvironment aEnv) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        aEnv.getPropertySources().forEach(ps -> UaaMapUtils.addAll(result, UaaMapUtils.getAllProperties(ps)));
        return result;
    }

    public static Map<String, Object> getAllProperties(PropertySource<?> aPropSource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (aPropSource instanceof CompositePropertySource) {
            CompositePropertySource cps = (CompositePropertySource)aPropSource;
            cps.getPropertySources().forEach(ps -> UaaMapUtils.addAll(result, UaaMapUtils.getAllProperties(ps)));
            return result;
        }
        if (aPropSource instanceof EnumerablePropertySource) {
            EnumerablePropertySource ps2 = (EnumerablePropertySource)aPropSource;
            Arrays.asList(ps2.getPropertyNames()).forEach(key -> result.put((String)key, ps2.getProperty(key)));
            return result;
        }
        return result;
    }

    private static void addAll(Map<String, Object> aBase, Map<String, Object> aToBeAdded) {
        for (Map.Entry<String, Object> entry : aToBeAdded.entrySet()) {
            if (aBase.containsKey(entry.getKey())) continue;
            aBase.put(entry.getKey(), entry.getValue());
        }
    }
}

