/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.client.RestTemplate;

public class ExceptionReportHttpMessageConverter
extends AbstractHttpMessageConverter<ExceptionReport> {
    private static final HttpMessageConverter<?>[] DEFAULT_MESSAGE_CONVERTERS = new RestTemplate().getMessageConverters().toArray(new HttpMessageConverter[0]);
    private HttpMessageConverter<?>[] messageConverters = DEFAULT_MESSAGE_CONVERTERS;

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    public List<MediaType> getSupportedMediaTypes() {
        LinkedHashSet list = new LinkedHashSet();
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            list.addAll(converter.getSupportedMediaTypes());
        }
        return new ArrayList<MediaType>(list);
    }

    protected boolean supports(Class<?> clazz) {
        return ExceptionReport.class.isAssignableFrom(clazz);
    }

    protected ExceptionReport readInternal(Class<? extends ExceptionReport> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            for (MediaType mediaType : converter.getSupportedMediaTypes()) {
                if (!converter.canRead(Map.class, mediaType)) continue;
                HttpMessageConverter<?> messageConverter = converter;
                Map map = (Map)messageConverter.read(Map.class, inputMessage);
                return new ExceptionReport(this.getException(map));
            }
        }
        return null;
    }

    private Exception getException(Map<String, String> map) {
        return new RuntimeException(map.get("message"));
    }

    protected void writeInternal(ExceptionReport report, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Exception e = report.getException();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", UaaStringUtils.getErrorName(e));
        map.put("message", e.getMessage());
        map.put("error_description", e.getMessage());
        if (report.getExtraInfo() != null) {
            map.putAll(report.getExtraInfo());
        }
        if (report.isTrace()) {
            StringWriter trace = new StringWriter();
            e.printStackTrace(new PrintWriter(trace));
            map.put("trace", trace.toString());
        }
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            for (MediaType mediaType : converter.getSupportedMediaTypes()) {
                if (!converter.canWrite(Map.class, mediaType)) continue;
                HttpMessageConverter<?> messageConverter = converter;
                messageConverter.write(map, mediaType, outputMessage);
                return;
            }
        }
    }
}

