/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.security.GeneralSecurityException;
import org.cloudfoundry.identity.uaa.util.KeyWithCert;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfigurationValidator;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneConfigurationException;
import org.cloudfoundry.identity.uaa.zone.SamlConfig;

public class GeneralIdentityZoneConfigurationValidator
implements IdentityZoneConfigurationValidator {
    @Override
    public IdentityZoneConfiguration validate(IdentityZoneConfiguration config, IdentityZoneConfigurationValidator.Mode mode) throws InvalidIdentityZoneConfigurationException {
        SamlConfig samlConfig;
        if ((mode == IdentityZoneConfigurationValidator.Mode.CREATE || mode == IdentityZoneConfigurationValidator.Mode.MODIFY) && (samlConfig = config.getSamlConfig()) != null) {
            try {
                String samlSpCert = samlConfig.getCertificate();
                String samlSpKey = samlConfig.getPrivateKey();
                String samlSpkeyPassphrase = samlConfig.getPrivateKeyPassword();
                if (samlSpKey != null && samlSpCert != null) {
                    KeyWithCert keyWithCert = new KeyWithCert(samlSpKey, samlSpkeyPassphrase, samlSpCert);
                }
            }
            catch (GeneralSecurityException ex) {
                throw new InvalidIdentityZoneConfigurationException("There is a security problem with the SAML SP configuration.", ex);
            }
        }
        return config;
    }
}

