/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.client.ClientMetadata;
import org.cloudfoundry.identity.uaa.client.ClientMetadataException;
import org.cloudfoundry.identity.uaa.client.ClientMetadataProvisioning;
import org.cloudfoundry.identity.uaa.web.ConvertingExceptionView;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.View;

@Controller
public class ClientMetadataAdminEndpoints {
    private ClientMetadataProvisioning clientMetadataProvisioning;
    private HttpMessageConverter<?>[] messageConverters;
    private static Log logger = LogFactory.getLog(ClientMetadataAdminEndpoints.class);

    @RequestMapping(value={"/oauth/clients/{client}/meta"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ClientMetadata retrieveClientMetadata(@PathVariable(value="client") String clientId) {
        try {
            return this.clientMetadataProvisioning.retrieve(clientId);
        }
        catch (EmptyResultDataAccessException erdae) {
            throw new ClientMetadataException("No client metadata found for " + clientId, HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/oauth/clients/meta"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<ClientMetadata> retrieveAllClientMetadata() {
        return this.clientMetadataProvisioning.retrieveAll();
    }

    @RequestMapping(value={"/oauth/clients/{client}/meta"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ClientMetadata updateClientMetadata(@RequestBody ClientMetadata clientMetadata, @PathVariable(value="client") String clientId) {
        if (StringUtils.hasText((String)clientMetadata.getClientId())) {
            if (!clientId.equals(clientMetadata.getClientId())) {
                throw new ClientMetadataException("Client ID in body {" + clientMetadata.getClientId() + "} does not match URL path {" + clientId + "}", HttpStatus.BAD_REQUEST);
            }
        } else {
            clientMetadata.setClientId(clientId);
        }
        try {
            return this.clientMetadataProvisioning.update(clientMetadata);
        }
        catch (EmptyResultDataAccessException e) {
            throw new ClientMetadataException("No client with ID " + clientMetadata.getClientId(), HttpStatus.NOT_FOUND);
        }
    }

    @ExceptionHandler
    public View handleException(ClientMetadataException cme, HttpServletRequest request) {
        logger.error((Object)"Unhandled exception in client metadata admin endpoints.", (Throwable)cme);
        boolean trace = request.getParameter("trace") != null && !request.getParameter("trace").equals("false");
        return new ConvertingExceptionView((ResponseEntity<? extends ExceptionReport>)new ResponseEntity((Object)new ExceptionReport(cme, trace, cme.getExtraInfo()), cme.getStatus()), this.messageConverters);
    }

    public void setClientMetadataProvisioning(ClientMetadataProvisioning clientMetadataProvisioning) {
        this.clientMetadataProvisioning = clientMetadataProvisioning;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }
}

