/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.resources.jdbc.AbstractQueryable;
import org.cloudfoundry.identity.uaa.resources.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.resources.jdbc.SearchQueryConverter;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceConstraintFailedException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.scim.jdbc.ScimSearchQueryConverter;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jca.cci.InvalidResultSetAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcScimGroupExternalMembershipManager
extends AbstractQueryable<ScimGroupExternalMember>
implements ScimGroupExternalMembershipManager {
    private JdbcTemplate jdbcTemplate;
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String EXTERNAL_GROUP_MAPPING_FIELDS = "group_id,external_group,added,origin";
    public static final String JOIN_EXTERNAL_GROUP_MAPPING_FIELDS = "gm.group_id,gm.external_group,gm.added,g.displayName,gm.origin";
    public static final String EXTERNAL_GROUP_MAPPING_TABLE = "external_group_mapping";
    public static final String GROUP_TABLE = "groups";
    public static final String JOIN_GROUP_TABLE = String.format("%s g, %s gm", "groups", "external_group_mapping");
    public static final String JOIN_WHERE_ID = "g.id = gm.group_id and gm.origin = ?";
    public static final String ADD_EXTERNAL_GROUP_MAPPING_SQL = String.format("insert into %s ( %s ) values (?,lower(?),?,?)", "external_group_mapping", "group_id,external_group,added,origin");
    public static final String GET_EXTERNAL_GROUP_MAPPINGS_SQL = String.format("select %s from %s where g.identity_zone_id=? and gm.group_id=? and %s", "gm.group_id,gm.external_group,gm.added,g.displayName,gm.origin", JOIN_GROUP_TABLE, "g.id = gm.group_id and gm.origin = ?");
    public static final String GET_GROUPS_BY_EXTERNAL_GROUP_MAPPING_SQL = String.format("select %s from %s where g.identity_zone_id=? and %s and lower(external_group)=lower(?)", "gm.group_id,gm.external_group,gm.added,g.displayName,gm.origin", JOIN_GROUP_TABLE, "g.id = gm.group_id and gm.origin = ?");
    public static final String GET_GROUPS_WITH_EXTERNAL_GROUP_MAPPINGS_SQL = String.format("select %s from %s where g.identity_zone_id=? and g.id=? and %s and lower(external_group) like lower(?)", "gm.group_id,gm.external_group,gm.added,g.displayName,gm.origin", JOIN_GROUP_TABLE, "g.id = gm.group_id and gm.origin = ?");
    public static final String DELETE_EXTERNAL_GROUP_MAPPING_SQL = String.format("delete from %s where group_id=? and lower(external_group)=lower(?) and origin=?", "external_group_mapping");
    public static final String DELETE_ALL_MAPPINGS_FOR_GROUP_SQL = String.format("delete from %s where group_id = ?", "external_group_mapping");
    private final RowMapper<ScimGroupExternalMember> rowMapper = new ScimGroupExternalMemberRowMapper();
    private ScimGroupProvisioning scimGroupProvisioning;

    public JdbcScimGroupExternalMembershipManager(JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory) {
        super(jdbcTemplate, pagingListFactory, new ScimGroupExternalMemberRowMapper());
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
        this.setQueryConverter(new ScimSearchQueryConverter());
    }

    protected String adjustFilterForJoin(String filter) {
        if (StringUtils.hasText((String)filter)) {
            filter = filter.replace("displayName", "g.displayName");
            filter = filter.replace("externalGroup", "gm.external_group");
            filter = filter.replace("groupId", "g.id");
            filter = filter.replace("origin", "gm.origin");
        }
        return filter;
    }

    @Override
    protected String getTableName() {
        return EXTERNAL_GROUP_MAPPING_TABLE;
    }

    @Override
    public List<ScimGroupExternalMember> query(String filter) {
        return super.query(filter);
    }

    @Override
    public int delete(String filter) {
        SearchQueryConverter.ProcessedFilter where = this.getQueryConverter().convert(filter, null, false);
        this.logger.debug((Object)("Filtering groups with SQL: " + where));
        try {
            String completeSql = "DELETE FROM " + this.getTableName() + " WHERE ";
            if (StringUtils.hasText((String)where.getSql())) {
                completeSql = completeSql + where.getSql() + " AND ";
            }
            completeSql = completeSql + "group_id IN (SELECT id FROM groups WHERE identity_zone_id='" + IdentityZoneHolder.get().getId() + "')";
            this.logger.debug((Object)("delete sql: " + completeSql + ", params: " + where.getParams()));
            return new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate).update(completeSql, where.getParams());
        }
        catch (DataAccessException e) {
            this.logger.debug((Object)("Filter '" + filter + "' generated invalid SQL"), (Throwable)e);
            throw new IllegalArgumentException("Invalid delete filter: " + filter);
        }
    }

    @Override
    public List<ScimGroupExternalMember> query(String filter, String sortBy, boolean ascending) {
        return super.query(this.adjustFilterForJoin(filter), sortBy, ascending);
    }

    @Override
    public ScimGroupExternalMember mapExternalGroup(final String groupId, final String externalGroup, final String origin) throws ScimResourceNotFoundException, MemberAlreadyExistsException {
        ScimGroup group = (ScimGroup)this.scimGroupProvisioning.retrieve(groupId);
        if (!StringUtils.hasText((String)externalGroup)) {
            throw new ScimResourceConstraintFailedException("external group must not be null when mapping an external group");
        }
        if (!StringUtils.hasText((String)origin)) {
            throw new ScimResourceConstraintFailedException("origin must not be null when mapping an external group");
        }
        if (null != group) {
            try {
                int result = this.jdbcTemplate.update(ADD_EXTERNAL_GROUP_MAPPING_SQL, new PreparedStatementSetter(){

                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setString(1, groupId);
                        ps.setString(2, externalGroup);
                        ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                        ps.setString(4, origin);
                    }
                });
                System.out.println("update count = " + result);
            }
            catch (DuplicateKeyException e) {
                this.logger.info((Object)("The mapping between group " + group.getDisplayName() + " and external group " + externalGroup + " already exists"));
            }
            return this.getExternalGroupMap(groupId, externalGroup, origin);
        }
        throw new ScimResourceNotFoundException("Group does not exist");
    }

    @Override
    public ScimGroupExternalMember unmapExternalGroup(final String groupId, final String externalGroup, final String origin) throws ScimResourceNotFoundException {
        ScimGroup group = (ScimGroup)this.scimGroupProvisioning.retrieve(groupId);
        ScimGroupExternalMember result = this.getExternalGroupMap(groupId, externalGroup, origin);
        if (null != group && null != result) {
            int count = this.jdbcTemplate.update(DELETE_EXTERNAL_GROUP_MAPPING_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, groupId);
                    ps.setString(2, externalGroup);
                    ps.setString(3, origin);
                }
            });
            if (count == 1) {
                return result;
            }
            if (count == 0) {
                throw new ScimResourceNotFoundException("No group mappings deleted.");
            }
            throw new InvalidResultSetAccessException("More than one mapping deleted count=" + count, new SQLException());
        }
        return null;
    }

    @Override
    public List<ScimGroupExternalMember> getExternalGroupMapsByGroupId(final String groupId, final String origin) throws ScimResourceNotFoundException {
        this.scimGroupProvisioning.retrieve(groupId);
        return this.jdbcTemplate.query(GET_EXTERNAL_GROUP_MAPPINGS_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, IdentityZoneHolder.get().getId());
                ps.setString(2, groupId);
                ps.setString(3, origin);
            }
        }, this.rowMapper);
    }

    @Override
    public List<ScimGroupExternalMember> getExternalGroupMapsByGroupName(String groupName, final String origin) throws ScimResourceNotFoundException {
        final List groups = this.scimGroupProvisioning.query(String.format("displayName eq \"%s\"", groupName));
        if (null != groups && groups.size() > 0) {
            return this.jdbcTemplate.query(GET_EXTERNAL_GROUP_MAPPINGS_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, IdentityZoneHolder.get().getId());
                    ps.setString(2, ((ScimGroup)groups.get(0)).getId());
                    ps.setString(3, origin);
                }
            }, this.rowMapper);
        }
        return null;
    }

    @Override
    public void unmapAll(final String groupId) throws ScimResourceNotFoundException {
        ScimGroup group = (ScimGroup)this.scimGroupProvisioning.retrieve(groupId);
        if (null == group) {
            throw new ScimResourceNotFoundException("Group not found for ID " + groupId);
        }
        this.jdbcTemplate.update(DELETE_ALL_MAPPINGS_FOR_GROUP_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
            }
        });
    }

    @Override
    public List<ScimGroupExternalMember> getExternalGroupMapsByExternalGroup(final String externalGroup, final String origin) throws ScimResourceNotFoundException {
        return this.jdbcTemplate.query(GET_GROUPS_BY_EXTERNAL_GROUP_MAPPING_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, IdentityZoneHolder.get().getId());
                ps.setString(2, origin);
                ps.setString(3, externalGroup);
            }
        }, this.rowMapper);
    }

    @Override
    protected String getQuerySQL(String filter, SearchQueryConverter.ProcessedFilter where) {
        boolean containsWhereClause = this.getBaseSqlQuery().contains(" where ");
        return filter == null || filter.trim().length() == 0 ? this.getBaseSqlQuery() : this.getBaseSqlQuery() + (containsWhereClause ? " and " : " where ") + where.getSql();
    }

    private ScimGroupExternalMember getExternalGroupMap(String groupId, String externalGroup, String origin) throws ScimResourceNotFoundException {
        try {
            ScimGroupExternalMember u = (ScimGroupExternalMember)this.jdbcTemplate.queryForObject(GET_GROUPS_WITH_EXTERNAL_GROUP_MAPPINGS_SQL, this.rowMapper, new Object[]{IdentityZoneHolder.get().getId(), groupId, origin, externalGroup});
            return u;
        }
        catch (EmptyResultDataAccessException e) {
            throw new ScimResourceNotFoundException("The mapping between groupId " + groupId + " and external group " + externalGroup + " does not exist");
        }
    }

    public void setScimGroupProvisioning(ScimGroupProvisioning scimGroupProvisioning) {
        this.scimGroupProvisioning = scimGroupProvisioning;
    }

    @Override
    protected String getBaseSqlQuery() {
        return String.format("select %s from %s where %s", JOIN_EXTERNAL_GROUP_MAPPING_FIELDS, JOIN_GROUP_TABLE, "g.id = gm.group_id and g.identity_zone_id='" + IdentityZoneHolder.get().getId() + "'");
    }

    @Override
    protected void validateOrderBy(String orderBy) throws IllegalArgumentException {
        super.validateOrderBy(orderBy, EXTERNAL_GROUP_MAPPING_FIELDS);
    }

    private static final class ScimGroupExternalMemberRowMapper
    implements RowMapper<ScimGroupExternalMember> {
        private ScimGroupExternalMemberRowMapper() {
        }

        public ScimGroupExternalMember mapRow(ResultSet rs, int rowNum) throws SQLException {
            String groupId = rs.getString(1);
            String externalGroup = rs.getString(2);
            Timestamp added = rs.getTimestamp(3);
            String displayName = rs.getString(4);
            String origin = rs.getString(5);
            ScimGroupExternalMember result = new ScimGroupExternalMember(groupId, externalGroup);
            result.setDisplayName(displayName);
            result.setOrigin(origin);
            result.getMeta().setCreated((Date)added);
            result.getMeta().setLastModified((Date)added);
            return result;
        }
    }
}

