/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.jwt.crypto.sign.Signer;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class UaaTokenUtils {
    public static final Pattern jwtPattern = Pattern.compile("[a-zA-Z0-9_\\-\\\\=]*\\.[a-zA-Z0-9_\\-\\\\=]*\\.[a-zA-Z0-9_\\-\\\\=]*");

    private UaaTokenUtils() {
    }

    public static String getRevocationHash(List<String> salts) {
        String result = "";
        for (String s : salts) {
            byte[] hashable = (result + "###" + s).getBytes();
            result = Integer.toHexString(UaaTokenUtils.murmurhash3x8632(hashable, 0, hashable.length, 61680));
        }
        return result;
    }

    public static int murmurhash3x8632(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= c1;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static Set<String> retainAutoApprovedScopes(Collection<String> requestedScopes, Set<String> autoApprovedScopes) {
        HashSet<String> result = new HashSet<String>();
        if (autoApprovedScopes == null) {
            return result;
        }
        if (autoApprovedScopes.contains("true")) {
            result.addAll(requestedScopes);
            return result;
        }
        Set autoApprovedScopePatterns = UaaStringUtils.constructWildcards(autoApprovedScopes);
        for (String scope : requestedScopes) {
            if (!UaaStringUtils.matches((Set)autoApprovedScopePatterns, (String)scope)) continue;
            result.add(scope);
        }
        return result;
    }

    public static boolean isUserToken(Map<String, Object> claims) {
        return !"client_credentials".equals(claims.get("grant_type")) || claims.get("sub") != null && claims.get("sub") == claims.get("cid");
    }

    public static String getRevocableTokenSignature(ClientDetails client, String clientSecret, UaaUser user) {
        String[] salts = new String[]{client.getClientId(), clientSecret, (String)client.getAdditionalInformation().get("token_salt"), user == null ? null : user.getId(), user == null ? null : user.getPassword(), user == null ? null : user.getSalt(), user == null ? null : user.getEmail(), user == null ? null : user.getUsername()};
        LinkedList<String> saltlist = new LinkedList<String>();
        for (String s : salts) {
            if (s == null) continue;
            saltlist.add(s);
        }
        return UaaTokenUtils.getRevocationHash(saltlist);
    }

    public static String constructToken(Map<String, Object> header, Map<String, Object> claims, Signer signer) {
        byte[] headerJson = header == null ? new byte[]{} : JsonUtils.writeValueAsBytes(header);
        byte[] claimsJson = claims == null ? new byte[]{} : JsonUtils.writeValueAsBytes(claims);
        String headerBase64 = Base64.encodeBase64URLSafeString((byte[])headerJson);
        String claimsBase64 = Base64.encodeBase64URLSafeString((byte[])claimsJson);
        String headerAndClaims = headerBase64 + "." + claimsBase64;
        byte[] signature = signer.sign(headerAndClaims.getBytes());
        String signatureBase64 = Base64.encodeBase64URLSafeString((byte[])signature);
        return headerAndClaims + "." + signatureBase64;
    }

    public static boolean isJwtToken(String token) {
        return jwtPattern.matcher(token).matches();
    }

    public static String constructTokenEndpointUrl(String issuer) throws URISyntaxException {
        try {
            new URL(issuer);
        }
        catch (MalformedURLException x) {
            throw new URISyntaxException(issuer, x.getMessage());
        }
        URI uri = new URI(issuer);
        String hostToUse = uri.getHost();
        if (StringUtils.hasText((String)IdentityZoneHolder.get().getSubdomain())) {
            hostToUse = IdentityZoneHolder.get().getSubdomain() + "." + hostToUse;
        }
        return UriComponentsBuilder.fromUriString((String)issuer).host(hostToUse).pathSegment(new String[]{"oauth/token"}).build().toUriString();
    }
}

