/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationJsonBase;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;

public class UaaAuthenticationDeserializer
extends JsonDeserializer<UaaAuthentication>
implements UaaAuthenticationJsonBase {
    public UaaAuthentication deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        UaaAuthenticationDetails details = null;
        UaaPrincipal princpal = null;
        List authorities = Collections.EMPTY_LIST;
        Set externalGroups = Collections.EMPTY_SET;
        long expiresAt = -1L;
        long authenticatedTime = -1L;
        boolean authenticated = false;
        Map userAttributes = Collections.EMPTY_MAP;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) continue;
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("null".equals(jp.getText())) continue;
            if ("details".equals(fieldName)) {
                details = (UaaAuthenticationDetails)jp.readValueAs(UaaAuthenticationDetails.class);
                continue;
            }
            if ("principal".equals(fieldName)) {
                princpal = (UaaPrincipal)jp.readValueAs(UaaPrincipal.class);
                continue;
            }
            if ("authorities".equals(fieldName)) {
                authorities = this.deserializeAuthorites((Collection)jp.readValueAs((TypeReference)new TypeReference<List<String>>(){}));
                continue;
            }
            if ("externalGroups".equals(fieldName)) {
                externalGroups = (Set)jp.readValueAs((TypeReference)new TypeReference<Set<String>>(){});
                continue;
            }
            if ("expiresAt".equals(fieldName)) {
                expiresAt = jp.getLongValue();
                continue;
            }
            if ("authenticatedTime".equals(fieldName)) {
                authenticatedTime = jp.getLongValue();
                continue;
            }
            if ("authenticated".equals(fieldName)) {
                authenticated = jp.getBooleanValue();
                continue;
            }
            if (!"userAttributes".equals(fieldName)) continue;
            userAttributes = (Map)jp.readValueAs((TypeReference)new TypeReference<Map<String, List<String>>>(){});
        }
        if (princpal == null) {
            throw new JsonMappingException("Missing " + UaaPrincipal.class.getName());
        }
        return new UaaAuthentication(princpal, null, authorities, externalGroups, userAttributes, details, authenticated, authenticatedTime, expiresAt);
    }
}

