/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.error;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.cloudfoundry.identity.uaa.error.UaaExceptionDeserializer;
import org.cloudfoundry.identity.uaa.error.UaaExceptionSerializer;

@JsonSerialize(using=UaaExceptionSerializer.class)
@JsonDeserialize(using=UaaExceptionDeserializer.class)
public class UaaException
extends RuntimeException {
    private static final String DEFAULT_ERROR = "unknown_error";
    private static final int DEFAULT_STATUS = 400;
    public static final String ERROR = "error";
    public static final String DESCRIPTION = "error_description";
    private static final String STATUS = "status";
    private Map<String, String> additionalInformation = null;
    private final int status;
    private final String error;

    public UaaException(String msg, Throwable t) {
        super(msg, t);
        this.error = DEFAULT_ERROR;
        this.status = 400;
    }

    public UaaException(String msg) {
        this(DEFAULT_ERROR, msg, 400);
    }

    public UaaException(String msg, int status) {
        this(DEFAULT_ERROR, msg, status);
    }

    public UaaException(String error, String description, int status) {
        super(description);
        this.error = error;
        this.status = status;
    }

    public UaaException(Throwable cause, String error, String description, int status) {
        super(description, cause);
        this.error = error;
        this.status = status;
    }

    public String getErrorCode() {
        return this.error;
    }

    public int getHttpStatus() {
        return this.status;
    }

    public Map<String, String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void addAdditionalInformation(String key, String value) {
        if (this.additionalInformation == null) {
            this.additionalInformation = new TreeMap<String, String>();
        }
        this.additionalInformation.put(key, value);
    }

    public static UaaException valueOf(Map<String, String> errorParams) {
        String errorCode = errorParams.get(ERROR);
        String errorMessage = errorParams.containsKey(DESCRIPTION) ? errorParams.get(DESCRIPTION) : null;
        int status = 400;
        if (errorParams.containsKey(STATUS)) {
            try {
                status = Integer.valueOf(errorParams.get(STATUS));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        UaaException ex = new UaaException(errorCode, errorMessage, status);
        Set<Map.Entry<String, String>> entries = errorParams.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            if (ERROR.equals(key) || DESCRIPTION.equals(key)) continue;
            ex.addAdditionalInformation(key, entry.getValue());
        }
        return ex;
    }

    @Override
    public String toString() {
        return this.getSummary();
    }

    public String getSummary() {
        Map<String, String> additionalParams;
        String errorMessage;
        StringBuilder builder = new StringBuilder();
        String delim = "";
        String error = this.getErrorCode();
        if (error != null) {
            builder.append(delim).append("error=\"").append(error).append("\"");
            delim = ", ";
        }
        if ((errorMessage = this.getMessage()) != null) {
            builder.append(delim).append("error_description=\"").append(errorMessage).append("\"");
            delim = ", ";
        }
        if ((additionalParams = this.getAdditionalInformation()) != null) {
            for (Map.Entry<String, String> param : additionalParams.entrySet()) {
                builder.append(delim).append(param.getKey()).append("=\"").append(param.getValue()).append("\"");
                delim = ", ";
            }
        }
        return builder.toString();
    }
}

