/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.resources.AttributeNameMapper;
import org.cloudfoundry.identity.uaa.resources.SearchResults;
import org.cloudfoundry.identity.uaa.resources.SimpleAttributeNameMapper;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class SearchResultsFactory {
    public static <T> SearchResults<Map<String, Object>> cropAndBuildSearchResultFrom(List<T> input, int startIndex, int count, int total, String[] attributes, List<String> schemas) {
        if (startIndex <= 0) {
            startIndex = 1;
        }
        if (startIndex - 1 >= input.size()) {
            count = 0;
        }
        if (startIndex - 1 + count >= input.size()) {
            count = input.size() - (startIndex - 1);
        }
        input = count > 0 ? input.subList(startIndex - 1, startIndex - 1 + count) : Collections.emptyList();
        return SearchResultsFactory.buildSearchResultFrom(input, startIndex, count, total, attributes, new SimpleAttributeNameMapper(Collections.emptyMap()), schemas);
    }

    public static <T> SearchResults<Map<String, Object>> buildSearchResultFrom(List<T> input, int startIndex, int count, int total, String[] attributes, List<String> schemas) {
        return SearchResultsFactory.buildSearchResultFrom(input, startIndex, count, total, attributes, new SimpleAttributeNameMapper(Collections.emptyMap()), schemas);
    }

    public static <T> SearchResults<Map<String, Object>> buildSearchResultFrom(List<T> input, int startIndex, int count, int total, String[] attributes, AttributeNameMapper mapper, List<String> schemas) {
        Assert.state((input.size() <= count ? 1 : 0) != 0, (String)"Cannot build search results from parent list. Use subList before you call this method.");
        Map<String, Expression> expressions = SearchResultsFactory.buildExpressions(attributes, mapper);
        StandardEvaluationContext context = new StandardEvaluationContext();
        ArrayList results = new ArrayList();
        for (T object : input) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String attribute : expressions.keySet()) {
                map.put(attribute, expressions.get(attribute).getValue((EvaluationContext)context, object));
            }
            results.add(map);
        }
        return new SearchResults(schemas, results, startIndex, count, total);
    }

    private static Map<String, Expression> buildExpressions(String[] attributes, AttributeNameMapper mapper) {
        LinkedHashMap<String, Expression> expressions = new LinkedHashMap<String, Expression>();
        for (String attribute : attributes) {
            String spel = mapper != null ? mapper.mapToInternal(attribute) : attribute;
            Expression expression = new SpelExpressionParser().parseExpression(spel);
            expressions.put(attribute, expression);
        }
        return expressions;
    }
}

