/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.manager.AuthEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalGroupAuthorizationEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.InvitedUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.NewUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberNotFoundException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScimUserBootstrap
implements InitializingBean,
ApplicationListener<AuthEvent> {
    private static final Log logger = LogFactory.getLog(ScimUserBootstrap.class);
    private final ScimUserProvisioning scimUserProvisioning;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupMembershipManager membershipManager;
    private boolean override = false;
    private final Collection<UaaUser> users;

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isOverride() {
        return this.override;
    }

    public ScimUserBootstrap(ScimUserProvisioning scimUserProvisioning, ScimGroupProvisioning scimGroupProvisioning, ScimGroupMembershipManager membershipManager, Collection<UaaUser> users) {
        Assert.notNull((Object)scimUserProvisioning, (String)"scimUserProvisioning cannot be null");
        Assert.notNull((Object)scimGroupProvisioning, (String)"scimGroupProvisioning cannont be null");
        Assert.notNull((Object)membershipManager, (String)"memberShipManager cannot be null");
        Assert.notNull(users, (String)"users list cannot be null");
        this.scimUserProvisioning = scimUserProvisioning;
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.membershipManager = membershipManager;
        this.users = Collections.unmodifiableCollection(users);
    }

    public void afterPropertiesSet() throws Exception {
        for (UaaUser u : this.users) {
            this.addUser(u);
        }
    }

    protected ScimUser getScimUser(UaaUser user) {
        List<Object> users = this.scimUserProvisioning.query("userName eq \"" + user.getUsername() + "\"" + " and origin eq \"" + (user.getOrigin() == null ? "uaa" : user.getOrigin()) + "\"");
        if (users.isEmpty() && StringUtils.hasText((String)user.getId())) {
            try {
                users = Arrays.asList((ScimUser)this.scimUserProvisioning.retrieve(user.getId()));
            }
            catch (ScimResourceNotFoundException x) {
                logger.debug((Object)("Unable to find scim user based on ID:" + user.getId()));
            }
        }
        return users.isEmpty() ? null : (ScimUser)users.get(0);
    }

    protected void addUser(UaaUser user) {
        ScimUser scimUser = this.getScimUser(user);
        if (scimUser == null) {
            this.createNewUser(user);
        } else if (this.override) {
            this.updateUser(scimUser, user);
        } else {
            logger.debug((Object)("Override flag not set. Not registering existing user: " + user));
        }
    }

    private void updateUser(ScimUser existingUser, UaaUser updatedUser) {
        this.updateUser(existingUser, updatedUser, true);
    }

    private void updateUser(ScimUser existingUser, UaaUser updatedUser, boolean updateGroups) {
        String id = existingUser.getId();
        logger.debug((Object)("Updating user account: " + updatedUser + " with SCIM Id: " + id));
        if (updateGroups) {
            logger.debug((Object)"Removing existing group memberships ...");
            Set<ScimGroup> existingGroups = this.membershipManager.getGroupsWithMember(id, true);
            for (ScimGroup g : existingGroups) {
                this.removeFromGroup(id, g.getDisplayName());
            }
        }
        ScimUser newScimUser = this.convertToScimUser(updatedUser);
        newScimUser.setVersion(existingUser.getVersion());
        this.scimUserProvisioning.update(id, newScimUser);
        if ("uaa".equals(newScimUser.getOrigin())) {
            this.scimUserProvisioning.changePassword(id, null, updatedUser.getPassword());
        }
        if (updateGroups) {
            Collection<String> newGroups = this.convertToGroups(updatedUser.getAuthorities());
            logger.debug((Object)("Adding new groups " + newGroups));
            this.addGroups(id, newGroups);
        }
    }

    private void createNewUser(UaaUser user) {
        logger.debug((Object)("Registering new user account: " + user));
        ScimUser newScimUser = this.scimUserProvisioning.createUser(this.convertToScimUser(user), user.getPassword());
        this.addGroups(newScimUser.getId(), this.convertToGroups(user.getAuthorities()));
    }

    private void addGroups(String scimUserid, Collection<String> groups) {
        for (String group : groups) {
            this.addToGroup(scimUserid, group);
        }
    }

    public void onApplicationEvent(AuthEvent event) {
        if (event instanceof InvitedUserAuthenticatedEvent) {
            ScimUser user = this.getScimUser(event.getUser());
            this.updateUser(user, event.getUser(), false);
            return;
        }
        if (event instanceof ExternalGroupAuthorizationEvent) {
            ExternalGroupAuthorizationEvent exEvent = (ExternalGroupAuthorizationEvent)event;
            String origin = exEvent.getUser().getOrigin();
            if (!"uaa".equals(origin)) {
                this.membershipManager.delete("member_id eq \"" + event.getUser().getId() + "\" and origin eq \"" + origin + "\"");
            }
            for (GrantedAuthority grantedAuthority : exEvent.getExternalAuthorities()) {
                this.addToGroup(exEvent.getUser().getId(), grantedAuthority.getAuthority(), exEvent.getUser().getOrigin(), exEvent.isAddGroups());
            }
            if (event.isUserModified()) {
                ScimUser user = this.getScimUser(event.getUser());
                this.updateUser(user, event.getUser(), false);
            }
            return;
        }
        if (event instanceof NewUserAuthenticatedEvent) {
            this.addUser(event.getUser());
            return;
        }
    }

    private void addToGroup(String scimUserId, String gName) {
        this.addToGroup(scimUserId, gName, "uaa", true);
    }

    private void addToGroup(String scimUserId, String gName, String origin, boolean addGroup) {
        ScimGroup group;
        if (!StringUtils.hasText((String)gName)) {
            return;
        }
        logger.debug((Object)("Adding to group: " + gName));
        List g = this.scimGroupProvisioning.query(String.format("displayName eq \"%s\"", gName));
        if ((g == null || g.isEmpty()) && !addGroup) {
            logger.debug((Object)("No group found with name:" + gName + ". Group membership will not be added."));
            return;
        }
        if (g == null || g.isEmpty()) {
            group = new ScimGroup(null, gName, IdentityZoneHolder.get().getId());
            group = this.scimGroupProvisioning.create(group);
        } else {
            group = (ScimGroup)g.get(0);
        }
        try {
            ScimGroupMember groupMember = new ScimGroupMember(scimUserId);
            groupMember.setOrigin(origin);
            this.membershipManager.addMember(group.getId(), groupMember);
        }
        catch (MemberAlreadyExistsException memberAlreadyExistsException) {
            // empty catch block
        }
    }

    private void removeFromGroup(String scimUserId, String gName) {
        if (!StringUtils.hasText((String)gName)) {
            return;
        }
        logger.debug((Object)("Removing membership of group: " + gName));
        List g = this.scimGroupProvisioning.query(String.format("displayName eq \"%s\"", gName));
        if (g == null || g.isEmpty()) {
            return;
        }
        ScimGroup group = (ScimGroup)g.get(0);
        try {
            this.membershipManager.removeMemberById(group.getId(), scimUserId);
        }
        catch (MemberNotFoundException memberNotFoundException) {
            // empty catch block
        }
    }

    private ScimUser convertToScimUser(UaaUser user) {
        ScimUser scim = new ScimUser(user.getId(), user.getUsername(), user.getGivenName(), user.getFamilyName());
        scim.addPhoneNumber(user.getPhoneNumber());
        scim.addEmail(user.getEmail());
        scim.setOrigin(user.getOrigin());
        scim.setExternalId(user.getExternalId());
        scim.setVerified(true);
        return scim;
    }

    private Collection<String> convertToGroups(List<? extends GrantedAuthority> authorities) {
        ArrayList<String> groups = new ArrayList<String>();
        for (GrantedAuthority grantedAuthority : authorities) {
            groups.add(grantedAuthority.toString());
        }
        return groups;
    }
}

