/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.resources.jdbc.AbstractQueryable;
import org.cloudfoundry.identity.uaa.resources.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.resources.jdbc.SearchQueryConverter;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidScimResourceException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberNotFoundException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceConstraintFailedException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcScimGroupMembershipManager
extends AbstractQueryable<ScimGroupMember>
implements ScimGroupMembershipManager {
    private JdbcTemplate jdbcTemplate;
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String MEMBERSHIP_FIELDS = "group_id,member_id,member_type,authorities,added,origin";
    public static final String MEMBERSHIP_TABLE = "group_membership";
    public static final String ADD_MEMBER_SQL = String.format("insert into %s ( %s ) values (?,?,?,?,?,?)", "group_membership", "group_id,member_id,member_type,authorities,added,origin");
    public static final String UPDATE_MEMBER_SQL = String.format("update %s set authorities=? where group_id=? and member_id=?", "group_membership");
    public static final String GET_MEMBERS_FILTER_SQL = String.format("select %s from %s where group_id in (select id from groups where identity_zone_id=%s)", "group_id,member_id,member_type,authorities,added,origin", "group_membership", "'%s'");
    public static final String GET_GROUPS_BY_MEMBER_SQL = String.format("select distinct(group_id) from %s where member_id=? and group_id in (select id from groups where identity_zone_id=?)", "group_membership");
    public static final String GET_MEMBERS_WITH_AUTHORITY_SQL = String.format("select %s from %s where group_id=? and lower(authorities) like ?", "group_id,member_id,member_type,authorities,added,origin", "group_membership");
    public static final String GET_MEMBER_SQL = String.format("select %s from %s where member_id=? and group_id in (select id from groups where id=? and identity_zone_id=?)", "group_id,member_id,member_type,authorities,added,origin", "group_membership");
    public static final String DELETE_MEMBER_SQL = String.format("delete from %s where member_id=? and group_id in (select id from groups where id=? and identity_zone_id=?)", "group_membership");
    public static final String DELETE_MEMBERS_IN_GROUP_SQL = String.format("delete from %s where group_id in (select id from groups where id=? and identity_zone_id=?)", "group_membership");
    public static final String DELETE_MEMBER_IN_GROUPS_SQL_USER = String.format("delete from %s where member_id in (select id from users where id=? and identity_zone_id=?)", "group_membership");
    public static final String DELETE_MEMBER_IN_GROUPS_SQL_GROUP = String.format("delete from %s where member_id in (select id from groups where id=? and identity_zone_id=?)", "group_membership");
    private ScimUserProvisioning userProvisioning;
    private ScimGroupProvisioning groupProvisioning;
    private Map<IdentityZone, Set<ScimGroup>> defaultUserGroups = new ConcurrentHashMap<IdentityZone, Set<ScimGroup>>();

    public void setDefaultUserGroups(Set<String> groupNames) {
        HashSet<Object> usergroups = new HashSet<Object>();
        for (String name : groupNames) {
            List g = this.groupProvisioning.query(String.format("displayName co \"%s\" and identity_zone_id eq \"" + IdentityZone.getUaa().getId() + "\"", name));
            if (!g.isEmpty()) {
                usergroups.add(g.get(0));
                continue;
            }
            usergroups.add(this.groupProvisioning.create(new ScimGroup(null, name, IdentityZone.getUaa().getId())));
        }
        this.defaultUserGroups.put(IdentityZone.getUaa(), usergroups);
    }

    public Set<ScimGroup> getDefaultUserGroups(IdentityZone zone) {
        Set<ScimGroup> groups = this.defaultUserGroups.get(zone);
        if (groups == null) {
            return Collections.EMPTY_SET;
        }
        return groups;
    }

    public void setScimUserProvisioning(ScimUserProvisioning userProvisioning) {
        this.userProvisioning = userProvisioning;
    }

    public void setScimGroupProvisioning(ScimGroupProvisioning groupProvisioning) {
        this.groupProvisioning = groupProvisioning;
    }

    public JdbcScimGroupMembershipManager(JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory) {
        super(jdbcTemplate, pagingListFactory, new ScimGroupMemberRowMapper());
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    protected String getBaseSqlQuery() {
        return String.format(GET_MEMBERS_FILTER_SQL, IdentityZoneHolder.get().getId());
    }

    @Override
    protected String getTableName() {
        return MEMBERSHIP_TABLE;
    }

    @Override
    public int delete(String filter) {
        SearchQueryConverter.ProcessedFilter where = this.getQueryConverter().convert(filter, null, false);
        this.logger.debug((Object)("Filtering groups with SQL: " + where));
        try {
            String completeSql = "DELETE FROM " + this.getTableName() + " WHERE group_id IN (SELECT id FROM groups WHERE identity_zone_id='" + IdentityZoneHolder.get().getId() + "') AND  " + where.getSql();
            this.logger.debug((Object)("delete sql: " + completeSql + ", params: " + where.getParams()));
            return new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate).update(completeSql, where.getParams());
        }
        catch (DataAccessException e) {
            this.logger.debug((Object)("Filter '" + filter + "' generated invalid SQL"), (Throwable)e);
            throw new IllegalArgumentException("Invalid delete filter: " + filter);
        }
    }

    @Override
    protected String getQuerySQL(String filter, SearchQueryConverter.ProcessedFilter where) {
        boolean containsWhereClause = this.getBaseSqlQuery().contains(" where ");
        return filter == null || filter.trim().length() == 0 ? this.getBaseSqlQuery() : this.getBaseSqlQuery() + (containsWhereClause ? " and " : " where ") + where.getSql();
    }

    public boolean isDefaultGroup(String groupId) {
        for (ScimGroup g : this.getDefaultUserGroups(IdentityZoneHolder.get())) {
            if (!g.getId().equals(groupId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ScimGroupMember addMember(final String groupId, final ScimGroupMember member) throws ScimResourceNotFoundException, MemberAlreadyExistsException {
        if (this.isDefaultGroup(groupId)) {
            throw new MemberAlreadyExistsException("Trying to add member to default group");
        }
        this.validateRequest(groupId, member);
        final String authorities = this.getGroupAuthorities(member);
        final String type = (member.getType() == null ? ScimGroupMember.Type.USER : member.getType()).toString();
        try {
            this.logger.debug((Object)("Associating group:" + groupId + " with member:" + member));
            this.jdbcTemplate.update(ADD_MEMBER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, groupId);
                    ps.setString(2, member.getMemberId());
                    ps.setString(3, type);
                    ps.setString(4, authorities);
                    ps.setTimestamp(5, new Timestamp(new java.util.Date().getTime()));
                    ps.setString(6, member.getOrigin());
                }
            });
        }
        catch (DuplicateKeyException e) {
            throw new MemberAlreadyExistsException(member.getMemberId() + " is already part of the group: " + groupId);
        }
        return this.getMemberById(groupId, member.getMemberId());
    }

    @Override
    public List<ScimGroupMember> getMembers(String groupId, String filter, boolean includeEntities) throws ScimResourceNotFoundException {
        String scopedFilter;
        if (StringUtils.hasText((String)filter)) {
            this.getQueryConverter().convert(filter, "member_id", true);
            scopedFilter = String.format("group_id eq \"%s\" and (%s)", groupId, filter);
        } else {
            scopedFilter = String.format("group_id eq \"%s\"", groupId);
        }
        List result = this.query(scopedFilter, "member_id", true);
        if (includeEntities) {
            for (ScimGroupMember member : result) {
                if (member.getType().equals((Object)ScimGroupMember.Type.USER)) {
                    ScimUser user = (ScimUser)this.userProvisioning.retrieve(member.getMemberId());
                    member.setEntity((ScimCore)user);
                    continue;
                }
                if (!member.getType().equals((Object)ScimGroupMember.Type.GROUP)) continue;
                ScimGroup group = (ScimGroup)this.groupProvisioning.retrieve(member.getMemberId());
                member.setEntity((ScimCore)group);
            }
        }
        return new ArrayList<ScimGroupMember>(result);
    }

    @Override
    public Set<ScimGroup> getGroupsWithMember(String memberId, boolean transitive) throws ScimResourceNotFoundException {
        ArrayList<ScimGroup> results = new ArrayList<ScimGroup>();
        this.getGroupsWithMember(results, memberId, transitive);
        if (this.isUser(memberId)) {
            results.addAll(this.getDefaultUserGroups(IdentityZoneHolder.get()));
        }
        return new HashSet<ScimGroup>(results);
    }

    private void getGroupsWithMember(List<ScimGroup> results, final String memberId, boolean transitive) {
        List groupIds;
        if (results == null) {
            return;
        }
        try {
            groupIds = this.jdbcTemplate.query(GET_GROUPS_BY_MEMBER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, memberId);
                    ps.setString(2, IdentityZoneHolder.get().getId());
                }
            }, (RowMapper)new SingleColumnRowMapper(String.class));
        }
        catch (EmptyResultDataAccessException ex) {
            groupIds = Collections.EMPTY_LIST;
        }
        for (String groupId : groupIds) {
            ScimGroup group;
            try {
                group = (ScimGroup)this.groupProvisioning.retrieve(groupId);
            }
            catch (ScimResourceNotFoundException ex) {
                continue;
            }
            if (results.contains(group)) continue;
            results.add(group);
            if (!transitive) continue;
            this.getGroupsWithMember(results, groupId, transitive);
        }
    }

    @Override
    public List<ScimGroupMember> getMembers(final String groupId, final ScimGroupMember.Role permission) throws ScimResourceNotFoundException {
        this.logger.debug((Object)("getting members of type: " + permission + " from group: " + groupId));
        ArrayList<ScimGroupMember> members = new ArrayList<ScimGroupMember>();
        members.addAll(this.jdbcTemplate.query(GET_MEMBERS_WITH_AUTHORITY_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
                ps.setString(2, "%" + permission.toString().toLowerCase() + "%");
            }
        }, this.rowMapper));
        return members;
    }

    @Override
    public ScimGroupMember getMemberById(String groupId, String memberId) throws ScimResourceNotFoundException, MemberNotFoundException {
        try {
            ScimGroupMember u = (ScimGroupMember)this.jdbcTemplate.queryForObject(GET_MEMBER_SQL, this.rowMapper, new Object[]{memberId, groupId, IdentityZoneHolder.get().getId()});
            return u;
        }
        catch (EmptyResultDataAccessException e) {
            throw new MemberNotFoundException("Member " + memberId + " does not exist in group " + groupId);
        }
    }

    @Override
    public ScimGroupMember updateMember(final String groupId, final ScimGroupMember member) throws ScimResourceNotFoundException, MemberNotFoundException {
        this.validateRequest(groupId, member);
        final String authorities = this.getGroupAuthorities(member);
        int updated = this.jdbcTemplate.update(UPDATE_MEMBER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, authorities);
                ps.setString(2, groupId);
                ps.setString(3, member.getMemberId());
            }
        });
        if (updated == 0) {
            throw new MemberNotFoundException("Member " + member.getMemberId() + " does not exist in group " + groupId);
        }
        if (updated != 1) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members updated", 1, updated);
        }
        return this.getMemberById(groupId, member.getMemberId());
    }

    @Override
    public List<ScimGroupMember> updateOrAddMembers(String groupId, List<ScimGroupMember> members) throws ScimResourceNotFoundException {
        List<ScimGroupMember> currentMembers = this.getMembers(groupId, null, false);
        this.logger.debug((Object)("current-members: " + currentMembers + ", in request: " + members));
        ArrayList<ScimGroupMember> currentMembersToRemove = new ArrayList<ScimGroupMember>(currentMembers);
        currentMembersToRemove.removeAll(members);
        this.logger.debug((Object)("removing members: " + currentMembersToRemove));
        for (ScimGroupMember scimGroupMember : currentMembersToRemove) {
            this.removeMemberById(groupId, scimGroupMember.getMemberId());
        }
        ArrayList<ScimGroupMember> newMembersToAdd = new ArrayList<ScimGroupMember>(members);
        newMembersToAdd.removeAll(currentMembers);
        this.logger.debug((Object)("adding new members: " + newMembersToAdd));
        for (ScimGroupMember member : newMembersToAdd) {
            this.addMember(groupId, member);
        }
        ArrayList<ScimGroupMember> arrayList = new ArrayList<ScimGroupMember>(members);
        arrayList.retainAll(currentMembers);
        this.logger.debug((Object)("updating members: " + arrayList));
        for (ScimGroupMember member : arrayList) {
            this.updateMember(groupId, member);
        }
        return this.getMembers(groupId, null, false);
    }

    @Override
    public ScimGroupMember removeMemberById(final String groupId, final String memberId) throws ScimResourceNotFoundException, MemberNotFoundException {
        ScimGroupMember member = this.getMemberById(groupId, memberId);
        int deleted = this.jdbcTemplate.update(DELETE_MEMBER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(2, groupId);
                ps.setString(1, memberId);
                ps.setString(3, IdentityZoneHolder.get().getId());
            }
        });
        if (deleted != 1) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", 1, deleted);
        }
        return member;
    }

    @Override
    public List<ScimGroupMember> removeMembersByGroupId(final String groupId) throws ScimResourceNotFoundException {
        List<ScimGroupMember> members = this.getMembers(groupId, null, false);
        this.logger.debug((Object)("removing " + members + " members from group: " + groupId));
        int deleted = this.jdbcTemplate.update(DELETE_MEMBERS_IN_GROUP_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
                ps.setString(2, IdentityZoneHolder.get().getId());
            }
        });
        if (deleted != members.size()) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", members.size(), deleted);
        }
        return members;
    }

    @Override
    public Set<ScimGroup> removeMembersByMemberId(final String memberId) throws ScimResourceNotFoundException {
        int expectedDelete;
        Set<ScimGroup> groups = this.getGroupsWithMember(memberId, false);
        this.logger.debug((Object)("removing " + memberId + " from groups: " + groups));
        int deleted = 0;
        String sql = DELETE_MEMBER_IN_GROUPS_SQL_GROUP;
        if (this.isUser(memberId)) {
            sql = DELETE_MEMBER_IN_GROUPS_SQL_USER;
        }
        deleted = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, memberId);
                ps.setString(2, IdentityZoneHolder.get().getId());
            }
        });
        int n = expectedDelete = this.isUser(memberId) ? groups.size() - this.getDefaultUserGroups(IdentityZoneHolder.get()).size() : groups.size();
        if (deleted != expectedDelete) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", expectedDelete, deleted);
        }
        return groups;
    }

    private boolean isUser(String uuid) {
        try {
            this.userProvisioning.retrieve(uuid);
            return true;
        }
        catch (ScimResourceNotFoundException ex) {
            return false;
        }
    }

    private void validateRequest(String groupId, ScimGroupMember member) {
        if (!(StringUtils.hasText((String)groupId) && StringUtils.hasText((String)member.getMemberId()) && StringUtils.hasText((String)member.getOrigin()))) {
            throw new InvalidScimResourceException("group-id, member-id, origin and member-type must be non-empty");
        }
        if (groupId.equals(member.getMemberId())) {
            throw new InvalidScimResourceException("trying to nest group within itself, aborting");
        }
        ScimGroup group = (ScimGroup)this.groupProvisioning.retrieve(groupId);
        String memberZoneId = member.getType() == ScimGroupMember.Type.GROUP ? ((ScimGroup)this.groupProvisioning.retrieve(member.getMemberId())).getZoneId() : ((ScimUser)this.userProvisioning.retrieve(member.getMemberId())).getZoneId();
        if (!memberZoneId.equals(group.getZoneId())) {
            throw new ScimResourceConstraintFailedException("The zone of the group and the member must be the same.");
        }
        if (!memberZoneId.equals(IdentityZoneHolder.get().getId())) {
            throw new ScimResourceConstraintFailedException("Unable to make membership changes in a different zone");
        }
    }

    private String getGroupAuthorities(ScimGroupMember member) {
        if (member.getRoles() != null && !member.getRoles().isEmpty()) {
            return StringUtils.collectionToCommaDelimitedString((Collection)member.getRoles());
        }
        return StringUtils.collectionToCommaDelimitedString((Collection)ScimGroupMember.GROUP_MEMBER);
    }

    private static final class ScimGroupMemberRowMapper
    implements RowMapper<ScimGroupMember> {
        private ScimGroupMemberRowMapper() {
        }

        public ScimGroupMember mapRow(ResultSet rs, int rowNum) throws SQLException {
            String memberId = rs.getString(2);
            String memberType = rs.getString(3);
            String authorities = rs.getString(4);
            Date added = rs.getDate(5);
            String origin = rs.getString(6);
            ScimGroupMember sgm = new ScimGroupMember(memberId, ScimGroupMember.Type.valueOf((String)memberType), this.getAuthorities(authorities));
            sgm.setOrigin(origin);
            return sgm;
        }

        private List<ScimGroupMember.Role> getAuthorities(String authorities) {
            ArrayList<ScimGroupMember.Role> result = new ArrayList<ScimGroupMember.Role>();
            for (String a : authorities.split(",")) {
                if ("read".equalsIgnoreCase(a)) {
                    a = "reader";
                } else if ("write".equalsIgnoreCase(a)) {
                    a = "writer";
                }
                result.add(ScimGroupMember.Role.valueOf((String)a.toUpperCase()));
            }
            return result;
        }
    }
}

