/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.user;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.user.UaaUserPrototype;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcUaaUserDatabase
implements UaaUserDatabase {
    public static final String USER_FIELDS = "id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior ";
    public static final String DEFAULT_USER_BY_USERNAME_QUERY = "select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior from users where lower(username) = ? and active=? and origin=? and identity_zone_id=?";
    public static final String DEFAULT_USER_BY_ID_QUERY = "select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior from users where id = ? and active=? and identity_zone_id=?";
    public static final String DEFAULT_USER_BY_EMAIL_AND_ORIGIN_QUERY = "select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior from users where lower(email)=? and active=? and origin=? and identity_zone_id=?";
    private String AUTHORITIES_QUERY = "select g.id,g.displayName from groups g, group_membership m where g.id = m.group_id and m.member_id = ? and g.identity_zone_id=?";
    private JdbcTemplate jdbcTemplate;
    private final RowMapper<UaaUser> mapper = new UaaUserRowMapper();
    private Set<String> defaultAuthorities = new HashSet<String>();

    public void setDefaultAuthorities(Set<String> defaultAuthorities) {
        this.defaultAuthorities = defaultAuthorities;
    }

    public JdbcUaaUserDatabase(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public UaaUser retrieveUserByName(String username, String origin) throws UsernameNotFoundException {
        try {
            return (UaaUser)this.jdbcTemplate.queryForObject(DEFAULT_USER_BY_USERNAME_QUERY, this.mapper, new Object[]{username.toLowerCase(Locale.US), true, origin, IdentityZoneHolder.get().getId()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new UsernameNotFoundException(username);
        }
    }

    @Override
    public UaaUser retrieveUserById(String id) throws UsernameNotFoundException {
        try {
            return (UaaUser)this.jdbcTemplate.queryForObject(DEFAULT_USER_BY_ID_QUERY, this.mapper, new Object[]{id, true, IdentityZoneHolder.get().getId()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new UsernameNotFoundException(id);
        }
    }

    @Override
    public UaaUser retrieveUserByEmail(String email, String origin) throws UsernameNotFoundException {
        List results = this.jdbcTemplate.query(DEFAULT_USER_BY_EMAIL_AND_ORIGIN_QUERY, this.mapper, new Object[]{email.toLowerCase(Locale.US), true, origin, IdentityZoneHolder.get().getId()});
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return (UaaUser)results.get(0);
        }
        throw new IncorrectResultSizeDataAccessException(String.format("Multiple users match email=%s origin=%s", email, origin), 1, results.size());
    }

    private final class UaaUserRowMapper
    implements RowMapper<UaaUser> {
        private UaaUserRowMapper() {
        }

        public UaaUser mapRow(ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString(1);
            UaaUserPrototype prototype = new UaaUserPrototype().withId(id).withUsername(rs.getString(2)).withPassword(rs.getString(3)).withEmail(rs.getString(4)).withGivenName(rs.getString(5)).withFamilyName(rs.getString(6)).withCreated(rs.getTimestamp(7)).withModified(rs.getTimestamp(8)).withAuthorities(this.getDefaultAuthorities(rs.getString(9))).withOrigin(rs.getString(10)).withExternalId(rs.getString(11)).withVerified(rs.getBoolean(12)).withZoneId(rs.getString(13)).withSalt(rs.getString(14)).withPasswordLastModified(rs.getTimestamp(15)).withPhoneNumber(rs.getString(16)).withLegacyVerificationBehavior(rs.getBoolean(17));
            List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)this.getAuthorities(id));
            return new UaaUser(prototype.withAuthorities(authorities));
        }

        private List<GrantedAuthority> getDefaultAuthorities(String defaultAuth) {
            ArrayList authorities = new ArrayList();
            authorities.addAll(StringUtils.commaDelimitedListToSet((String)defaultAuth));
            authorities.addAll(JdbcUaaUserDatabase.this.defaultAuthorities);
            String authsString = StringUtils.collectionToCommaDelimitedString(new HashSet(authorities));
            return AuthorityUtils.commaSeparatedStringToAuthorityList((String)authsString);
        }

        private String getAuthorities(String userId) {
            HashSet<String> authorities = new HashSet<String>();
            this.getAuthorities(authorities, userId);
            authorities.addAll(JdbcUaaUserDatabase.this.defaultAuthorities);
            return StringUtils.collectionToCommaDelimitedString(new HashSet<String>(authorities));
        }

        protected void getAuthorities(Set<String> authorities, String memberId) {
            try {
                List results = JdbcUaaUserDatabase.this.jdbcTemplate.queryForList(JdbcUaaUserDatabase.this.AUTHORITIES_QUERY, new Object[]{memberId, IdentityZoneHolder.get().getId()});
                for (Map record : results) {
                    String displayName = (String)record.get("displayName");
                    String groupId = (String)record.get("id");
                    if (authorities.contains(displayName)) continue;
                    authorities.add(displayName);
                    this.getAuthorities(authorities, groupId);
                }
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                // empty catch block
            }
        }
    }
}

