/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.AbstractClientParametersAuthenticationFilter;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;

public class LoginClientParametersAuthenticationFilter
extends AbstractClientParametersAuthenticationFilter {
    @Override
    public void wrapClientCredentialLogin(HttpServletRequest req, HttpServletResponse res, Map<String, String> loginInfo, String clientId) throws IOException, ServletException {
        try {
            if (loginInfo.isEmpty()) {
                throw new BadCredentialsException("Request does not contain credentials.");
            }
            if (this.clientAuthenticationManager == null || loginInfo.get("client_id") == null) {
                this.logger.debug((Object)("Insufficient resources to perform client authentication. AuthMgr:" + this.clientAuthenticationManager + "; clientId:" + clientId));
                throw new BadCredentialsException("Request does not contain client credentials.");
            }
            this.logger.debug((Object)("Located credentials in request, with keys: " + loginInfo.keySet()));
            this.doClientCredentialLogin(req, loginInfo, clientId);
        }
        catch (AuthenticationException e) {
            this.logger.debug((Object)"Client Parameter Authentication failed");
            this.authenticationEntryPoint.commence(req, res, e);
            return;
        }
    }
}

