/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.account.AccountCreationService;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.message.MessageService;
import org.cloudfoundry.identity.uaa.message.MessageType;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.util.ScimUtils;
import org.cloudfoundry.identity.uaa.scim.validate.PasswordValidator;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring4.SpringTemplateEngine;

public class EmailAccountCreationService
implements AccountCreationService {
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String SIGNUP_REDIRECT_URL = "signup_redirect_url";
    private final SpringTemplateEngine templateEngine;
    private final MessageService messageService;
    private final ExpiringCodeStore codeStore;
    private final ScimUserProvisioning scimUserProvisioning;
    private final ClientDetailsService clientDetailsService;
    private final PasswordValidator passwordValidator;
    private final String companyName;

    public EmailAccountCreationService(SpringTemplateEngine templateEngine, MessageService messageService, ExpiringCodeStore codeStore, ScimUserProvisioning scimUserProvisioning, ClientDetailsService clientDetailsService, PasswordValidator passwordValidator, String companyName) {
        this.templateEngine = templateEngine;
        this.messageService = messageService;
        this.codeStore = codeStore;
        this.scimUserProvisioning = scimUserProvisioning;
        this.clientDetailsService = clientDetailsService;
        this.passwordValidator = passwordValidator;
        this.companyName = companyName;
    }

    @Override
    public void beginActivation(String email, String password, String clientId, String redirectUri) {
        this.passwordValidator.validate(password);
        String subject = this.getSubjectText();
        try {
            ScimUser scimUser = this.createUser(email, password, "uaa");
            this.generateAndSendCode(email, clientId, subject, scimUser.getId(), redirectUri);
        }
        catch (ScimResourceAlreadyExistsException e) {
            List users = this.scimUserProvisioning.query("userName eq \"" + email + "\" and origin eq \"" + "uaa" + "\"");
            try {
                if (users.size() > 0) {
                    if (((ScimUser)users.get(0)).isVerified()) {
                        throw new UaaException("User already active.", HttpStatus.CONFLICT.value());
                    }
                    this.generateAndSendCode(email, clientId, subject, ((ScimUser)users.get(0)).getId(), redirectUri);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Exception raised while creating account activation email for " + email), (Throwable)e);
        }
    }

    private void generateAndSendCode(String email, String clientId, String subject, String userId, String redirectUri) throws IOException {
        ExpiringCode expiringCode = ScimUtils.getExpiringCode(this.codeStore, userId, email, clientId, redirectUri);
        String htmlContent = this.getEmailHtml(expiringCode.getCode(), email);
        this.messageService.sendMessage(email, MessageType.CREATE_ACCOUNT_CONFIRMATION, subject, htmlContent);
    }

    @Override
    public AccountCreationService.AccountCreationResponse completeActivation(String code) throws IOException {
        ExpiringCode expiringCode = this.codeStore.retrieveCode(code);
        if (expiringCode == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST);
        }
        Map data = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve((String)data.get("user_id"));
        user = this.scimUserProvisioning.verifyUser(user.getId(), user.getVersion());
        String clientId = (String)data.get("client_id");
        String redirectUri = data.get("redirect_uri") != null ? (String)data.get("redirect_uri") : "";
        String redirectLocation = this.getRedirect(clientId, redirectUri);
        return new AccountCreationService.AccountCreationResponse(user.getId(), user.getUserName(), user.getUserName(), redirectLocation);
    }

    private String getRedirect(String clientId, String redirectUri) throws IOException {
        if (clientId != null) {
            try {
                ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
                Set registeredRedirectUris = clientDetails.getRegisteredRedirectUri() == null ? Collections.emptySet() : clientDetails.getRegisteredRedirectUri();
                String signupRedirectUrl = (String)clientDetails.getAdditionalInformation().get(SIGNUP_REDIRECT_URL);
                String matchingRedirectUri = UaaUrlUtils.findMatchingRedirectUri(registeredRedirectUris, redirectUri, signupRedirectUrl);
                if (matchingRedirectUri != null) {
                    return matchingRedirectUri;
                }
            }
            catch (NoSuchClientException nsce) {
                this.logger.debug((Object)String.format("Unable to find client with ID:%s for account activation redirect", clientId), (Throwable)nsce);
            }
        }
        return this.getDefaultRedirect();
    }

    @Override
    public String getDefaultRedirect() throws IOException {
        return "home";
    }

    @Override
    public ScimUser createUser(String username, String password, String origin) {
        ScimUser scimUser = new ScimUser();
        scimUser.setUserName(username);
        ScimUser.Email email = new ScimUser.Email();
        email.setPrimary(true);
        email.setValue(username);
        scimUser.setEmails(Arrays.asList(email));
        scimUser.setOrigin(origin);
        scimUser.setPassword(password);
        scimUser.setVerified(false);
        try {
            ScimUser userResponse = this.scimUserProvisioning.createUser(scimUser, password);
            return userResponse;
        }
        catch (RuntimeException x) {
            if (x instanceof ScimResourceAlreadyExistsException) {
                throw x;
            }
            throw new UaaException("Couldn't create user:" + username, x);
        }
    }

    private String getSubjectText() {
        return StringUtils.hasText((String)this.companyName) && IdentityZoneHolder.isUaa() ? "Activate your " + this.companyName + " account" : "Activate your account";
    }

    private String getEmailHtml(String code, String email) {
        String accountsUrl = ScimUtils.getVerificationURL(null).toString();
        Context ctx = new Context();
        if (IdentityZoneHolder.isUaa()) {
            ctx.setVariable("serviceName", (Object)(StringUtils.hasText((String)this.companyName) ? this.companyName : "Cloud Foundry"));
        } else {
            ctx.setVariable("serviceName", (Object)IdentityZoneHolder.get().getName());
        }
        ctx.setVariable("servicePhrase", (Object)(StringUtils.hasText((String)this.companyName) && IdentityZoneHolder.isUaa() ? this.companyName + " account" : "an account"));
        ctx.setVariable("code", (Object)code);
        ctx.setVariable("email", (Object)email);
        ctx.setVariable("accountsUrl", (Object)accountsUrl);
        return this.templateEngine.process("activate", (IContext)ctx);
    }
}

