/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.cloudfoundry.identity.uaa.authentication.AuthzAuthenticationRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.login.AutologinRequest;
import org.cloudfoundry.identity.uaa.login.AutologinResponse;
import org.cloudfoundry.identity.uaa.login.PasscodeInformation;
import org.cloudfoundry.identity.uaa.login.Prompt;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.LoginSamlAuthenticationToken;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.SamlRedirectUtils;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.MapCollector;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class LoginInfoEndpoint {
    public static final String NotANumber = "NaN";
    public static final String CREATE_ACCOUNT_LINK = "createAccountLink";
    public static final String FORGOT_PASSWORD_LINK = "forgotPasswordLink";
    public static final String LINK_CREATE_ACCOUNT_SHOW = "linkCreateAccountShow";
    public static final String FIELD_USERNAME_SHOW = "fieldUsernameShow";
    public static final List<String> UI_ONLY_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("createAccountLink", "forgotPasswordLink", "linkCreateAccountShow", "fieldUsernameShow"));
    public static final String PASSCODE = "passcode";
    public static final String SHOW_LOGIN_LINKS = "showLoginLinks";
    public static final String LINKS = "links";
    public static final String ZONE_NAME = "zone_name";
    public static final String ENTITY_ID = "entityID";
    public static final String IDP_DEFINITIONS = "idpDefinitions";
    public static final String OAUTH_DEFINITIONS = "oauthDefinitions";
    private Properties gitProperties = new Properties();
    private Properties buildProperties = new Properties();
    private String baseUrl;
    private String externalLoginUrl;
    private String samlSPBaseUrl;
    private String uaaHost;
    private SamlIdentityProviderConfigurator idpDefinitions;
    private long codeExpirationMillis = 300000L;
    private AuthenticationManager authenticationManager;
    private ExpiringCodeStore expiringCodeStore;
    private ClientDetailsService clientDetailsService;
    private IdentityProviderProvisioning providerProvisioning;
    private static MapCollector<IdentityProvider, String, AbstractXOAuthIdentityProviderDefinition> idpsMapCollector = new MapCollector<IdentityProvider, String, AbstractXOAuthIdentityProviderDefinition>(idp -> idp.getOriginKey(), idp -> (AbstractXOAuthIdentityProviderDefinition)idp.getConfig());
    private String entityID = "";
    private static final Pattern urlPattern = Pattern.compile("((https?|ftp|gopher|telnet|file):((//)|(\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)", 2);

    public void setExpiringCodeStore(ExpiringCodeStore expiringCodeStore) {
        this.expiringCodeStore = expiringCodeStore;
    }

    public long getCodeExpirationMillis() {
        return this.codeExpirationMillis;
    }

    public void setCodeExpirationMillis(long codeExpirationMillis) {
        this.codeExpirationMillis = codeExpirationMillis;
    }

    public void setIdpDefinitions(SamlIdentityProviderConfigurator idpDefinitions) {
        this.idpDefinitions = idpDefinitions;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }

    public LoginInfoEndpoint() {
        try {
            this.gitProperties = PropertiesLoaderUtils.loadAllProperties((String)"git.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.buildProperties = PropertiesLoaderUtils.loadAllProperties((String)"build.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @RequestMapping(value={"/login"}, headers={"Accept=application/json"})
    public String loginForJson(Model model, Principal principal) {
        return this.login(model, principal, Collections.emptyList(), true);
    }

    @RequestMapping(value={"/info"}, headers={"Accept=application/json"})
    public String infoForJson(Model model, Principal principal) {
        return this.login(model, principal, Collections.emptyList(), true);
    }

    @RequestMapping(value={"/info"}, headers={"Accept=text/html, */*"})
    public String infoForHtml(Model model, Principal principal) {
        return this.login(model, principal, Arrays.asList(PASSCODE), false);
    }

    @RequestMapping(value={"/login"}, headers={"Accept=text/html, */*"})
    public String loginForHtml(Model model, Principal principal, HttpServletRequest request) {
        return this.login(model, principal, Arrays.asList(PASSCODE), false, request);
    }

    @RequestMapping(value={"/invalid_request"})
    public String invalidRequest(HttpServletRequest request) {
        return "invalid_request";
    }

    protected String getZonifiedEntityId() {
        return SamlRedirectUtils.getZonifiedEntityId(this.entityID);
    }

    private String login(Model model, Principal principal, List<String> excludedPrompts, boolean jsonResponse) {
        return this.login(model, principal, excludedPrompts, jsonResponse, null);
    }

    private String login(Model model, Principal principal, List<String> excludedPrompts, boolean jsonResponse, HttpServletRequest request) {
        HttpSession session = request != null ? request.getSession(false) : null;
        List<String> allowedIdps = this.getAllowedIdps(session);
        List<SamlIdentityProviderDefinition> idps = this.getSamlIdentityProviderDefinitions(allowedIdps);
        Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdentityProviderDefinitions = this.getOauthIdentityProviderDefinitions();
        boolean fieldUsernameShow = true;
        IdentityProvider ldapIdentityProvider = null;
        try {
            ldapIdentityProvider = this.providerProvisioning.retrieveByOrigin("ldap", IdentityZoneHolder.get().getId());
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        IdentityProvider uaaIdentityProvider = this.providerProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
        if (!(uaaIdentityProvider.isActive() || ldapIdentityProvider != null && ldapIdentityProvider.isActive())) {
            fieldUsernameShow = false;
        }
        if (!(allowedIdps == null || allowedIdps.contains("ldap") || allowedIdps.contains("uaa") || allowedIdps.contains("keystone"))) {
            fieldUsernameShow = false;
        }
        if (!jsonResponse && !fieldUsernameShow) {
            if ((oauthIdentityProviderDefinitions == null || oauthIdentityProviderDefinitions.isEmpty()) && idps != null && idps.size() == 1) {
                String url = SamlRedirectUtils.getIdpRedirectUrl(idps.get(0), this.entityID);
                return "redirect:" + url;
            }
            if ((idps == null || idps.isEmpty()) && oauthIdentityProviderDefinitions != null && oauthIdentityProviderDefinitions.size() == 1) {
                try {
                    Map.Entry entry = (Map.Entry)oauthIdentityProviderDefinitions.entrySet().stream().findAny().get();
                    String alias = (String)entry.getKey();
                    AbstractXOAuthIdentityProviderDefinition definition = (AbstractXOAuthIdentityProviderDefinition)entry.getValue();
                    String authUrlBase = definition.getAuthUrl().toString();
                    String queryAppendDelimiter = authUrlBase.contains("?") ? "&" : "?";
                    ArrayList<String> query = new ArrayList<String>();
                    query.add("client_id=" + definition.getRelyingPartyId());
                    query.add("response_type=code");
                    query.add("redirect_uri=" + URLEncoder.encode(request.getRequestURL() + "/callback/" + alias, "UTF-8"));
                    if (definition.getScopes() != null && !definition.getScopes().isEmpty()) {
                        query.add("scope=" + URLEncoder.encode(String.join((CharSequence)" ", definition.getScopes()), "UTF-8"));
                    }
                    String queryString = String.join((CharSequence)"&", query);
                    return "redirect:" + authUrlBase + queryAppendDelimiter + queryString;
                }
                catch (UnsupportedEncodingException entry) {
                    // empty catch block
                }
            }
        }
        boolean linkCreateAccountShow = fieldUsernameShow;
        if (fieldUsernameShow && allowedIdps != null && !allowedIdps.contains("uaa")) {
            linkCreateAccountShow = false;
        }
        String zonifiedEntityID = this.getZonifiedEntityId();
        Map<String, ?> links = this.getLinksInfo();
        if (jsonResponse) {
            for (String attribute : UI_ONLY_ATTRIBUTES) {
                links.remove(attribute);
            }
            HashMap<String, String> idpDefinitionsForJson = new HashMap<String, String>();
            if (idps != null) {
                for (SamlIdentityProviderDefinition def : idps) {
                    String idpUrl = links.get("login") + String.format("/saml/discovery?returnIDParam=idp&entityID=%s&idp=%s&isPassive=true", zonifiedEntityID, def.getIdpEntityAlias());
                    idpDefinitionsForJson.put(def.getIdpEntityAlias(), idpUrl);
                }
                model.addAttribute(IDP_DEFINITIONS, idpDefinitionsForJson);
            }
        } else {
            model.addAttribute(LINK_CREATE_ACCOUNT_SHOW, (Object)linkCreateAccountShow);
            model.addAttribute(FIELD_USERNAME_SHOW, (Object)fieldUsernameShow);
            model.addAttribute(IDP_DEFINITIONS, idps);
            model.addAttribute(OAUTH_DEFINITIONS, oauthIdentityProviderDefinitions);
        }
        model.addAttribute(LINKS, links);
        this.setCommitInfo(model);
        model.addAttribute(ZONE_NAME, (Object)IdentityZoneHolder.get().getName());
        model.addAttribute(ENTITY_ID, (Object)zonifiedEntityID);
        boolean noIdpsPresent = true;
        for (SamlIdentityProviderDefinition idp : idps) {
            if (!idp.isShowSamlLink()) continue;
            model.addAttribute(SHOW_LOGIN_LINKS, (Object)true);
            noIdpsPresent = false;
            break;
        }
        for (AbstractXOAuthIdentityProviderDefinition oauthIdp : oauthIdentityProviderDefinitions.values()) {
            if (!oauthIdp.isShowLinkText()) continue;
            model.addAttribute(SHOW_LOGIN_LINKS, (Object)true);
            noIdpsPresent = false;
            break;
        }
        excludedPrompts = new LinkedList<String>(excludedPrompts);
        if (noIdpsPresent) {
            excludedPrompts.add(PASSCODE);
        }
        this.populatePrompts(model, excludedPrompts, jsonResponse);
        if (principal == null) {
            return "login";
        }
        return "home";
    }

    protected List<SamlIdentityProviderDefinition> getSamlIdentityProviderDefinitions(List<String> allowedIdps) {
        return this.idpDefinitions.getIdentityProviderDefinitions(allowedIdps, IdentityZoneHolder.get());
    }

    protected Map<String, AbstractXOAuthIdentityProviderDefinition> getOauthIdentityProviderDefinitions() {
        List<String> types = Arrays.asList("oauth2.0", "oidc1.0");
        List<IdentityProvider> identityProviders = this.providerProvisioning.retrieveAll(true, IdentityZoneHolder.get().getId());
        Map identityProviderDefinitions = (Map)identityProviders.stream().filter(p -> types.contains(p.getType())).collect(idpsMapCollector);
        return identityProviderDefinitions;
    }

    protected boolean hasSavedOauthAuthorizeRequest(HttpSession session) {
        if (session == null || session.getAttribute("SPRING_SECURITY_SAVED_REQUEST") == null) {
            return false;
        }
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        String redirectUrl = savedRequest.getRedirectUrl();
        String[] client_ids = savedRequest.getParameterValues("client_id");
        return redirectUrl != null && redirectUrl.contains("/oauth/authorize") && client_ids != null && client_ids.length != 0;
    }

    public List<String> getAllowedIdps(HttpSession session) {
        if (!this.hasSavedOauthAuthorizeRequest(session)) {
            return null;
        }
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        String[] client_ids = savedRequest.getParameterValues("client_id");
        try {
            ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(client_ids[0]);
            return (List)clientDetails.getAdditionalInformation().get("allowedproviders");
        }
        catch (NoSuchClientException x) {
            return null;
        }
    }

    private void setCommitInfo(Model model) {
        model.addAttribute("commit_id", (Object)this.gitProperties.getProperty("git.commit.id.abbrev", "UNKNOWN"));
        model.addAttribute("timestamp", (Object)this.gitProperties.getProperty("git.commit.time", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date())));
        model.addAttribute("app", UaaStringUtils.getMapFromProperties(this.buildProperties, "build."));
    }

    public void populatePrompts(Model model, List<String> exclude, boolean jsonResponse) {
        IdentityZoneConfiguration zoneConfiguration = IdentityZoneHolder.get().getConfig();
        if (Objects.isNull(zoneConfiguration)) {
            zoneConfiguration = new IdentityZoneConfiguration();
        }
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        for (Prompt prompt : zoneConfiguration.getPrompts()) {
            String urlInPasscode;
            if (exclude.contains(prompt.getName())) continue;
            String[] details = prompt.getDetails();
            if (PASSCODE.equals(prompt.getName()) && !IdentityZoneHolder.isUaa() && StringUtils.hasText((String)(urlInPasscode = this.extractUrlFromString(prompt.getDetails()[1])))) {
                String[] newDetails = new String[details.length];
                System.arraycopy(details, 0, newDetails, 0, details.length);
                newDetails[1] = newDetails[1].replace(urlInPasscode, UaaUrlUtils.addSubdomainToUrl(urlInPasscode));
                details = newDetails;
            }
            map.put(prompt.getName(), details);
        }
        model.addAttribute("prompts", map);
    }

    public String extractUrlFromString(String s) {
        Matcher matcher = urlPattern.matcher(s);
        if (matcher.find()) {
            int matchStart = matcher.start(0);
            int matchEnd = matcher.end(0);
            return s.substring(matchStart, matchEnd);
        }
        return null;
    }

    @RequestMapping(value={"/autologin"}, method={RequestMethod.POST})
    @ResponseBody
    public AutologinResponse generateAutologinCode(@RequestBody AutologinRequest request, @RequestHeader(value="Authorization", required=false) String auth) throws Exception {
        UaaPrincipal p;
        if (auth == null || !auth.startsWith("Basic")) {
            throw new BadCredentialsException("No basic authorization client information in request");
        }
        String username = request.getUsername();
        if (username == null) {
            throw new BadCredentialsException("No username in request");
        }
        Authentication userAuthentication = null;
        if (this.authenticationManager != null) {
            String password = request.getPassword();
            if (!StringUtils.hasText((String)password)) {
                throw new BadCredentialsException("No password in request");
            }
            userAuthentication = this.authenticationManager.authenticate((Authentication)new AuthzAuthenticationRequest(username, password, null));
        }
        String base64Credentials = auth.substring("Basic".length()).trim();
        new Base64();
        String credentials = new String(Base64.decode((byte[])base64Credentials.getBytes()), Charset.forName("UTF-8"));
        String[] values = credentials.split(":", 2);
        if (values == null || values.length == 0) {
            throw new BadCredentialsException("Invalid authorization header.");
        }
        String clientId = values[0];
        HashMap<String, String> codeData = new HashMap<String, String>();
        codeData.put("client_id", clientId);
        codeData.put("username", username);
        codeData.put("action", ExpiringCodeType.AUTOLOGIN.name());
        if (userAuthentication != null && userAuthentication.getPrincipal() instanceof UaaPrincipal && (p = (UaaPrincipal)userAuthentication.getPrincipal()) != null) {
            codeData.put("user_id", p.getId());
            codeData.put("origin", p.getOrigin());
        }
        ExpiringCode expiringCode = this.expiringCodeStore.generateCode(JsonUtils.writeValueAsString(codeData), new Timestamp(System.currentTimeMillis() + 300000L), null);
        return new AutologinResponse(expiringCode.getCode());
    }

    @RequestMapping(value={"/autologin"}, method={RequestMethod.GET})
    public String performAutologin(HttpSession session) {
        String redirectLocation = "home";
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        if (savedRequest != null && savedRequest.getRedirectUrl() != null) {
            redirectLocation = savedRequest.getRedirectUrl();
        }
        return "redirect:" + redirectLocation;
    }

    @RequestMapping(value={"/login/callback/{origin}"}, method={RequestMethod.GET})
    public String handleXOAuthCallback(HttpSession session) {
        String redirectLocation = "/home";
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        if (savedRequest != null && savedRequest.getRedirectUrl() != null) {
            redirectLocation = savedRequest.getRedirectUrl();
        }
        return "redirect:" + redirectLocation;
    }

    @RequestMapping(value={"/passcode"}, method={RequestMethod.GET})
    public String generatePasscode(Map<String, Object> model, Principal principal) throws NoSuchAlgorithmException, IOException {
        String origin;
        String username;
        UaaPrincipal uaaPrincipal;
        String userId = NotANumber;
        Map<String, Object> authorizationParameters = null;
        if (principal instanceof UaaPrincipal) {
            uaaPrincipal = (UaaPrincipal)principal;
            username = uaaPrincipal.getName();
            origin = uaaPrincipal.getOrigin();
            userId = uaaPrincipal.getId();
        } else if (principal instanceof UaaAuthentication) {
            uaaPrincipal = ((UaaAuthentication)((Object)principal)).getPrincipal();
            username = uaaPrincipal.getName();
            origin = uaaPrincipal.getOrigin();
            userId = uaaPrincipal.getId();
        } else if (principal instanceof LoginSamlAuthenticationToken) {
            username = principal.getName();
            origin = ((LoginSamlAuthenticationToken)((Object)principal)).getUaaPrincipal().getOrigin();
            userId = ((LoginSamlAuthenticationToken)((Object)principal)).getUaaPrincipal().getId();
        } else if (principal instanceof Authentication && ((Authentication)principal).getPrincipal() instanceof UaaPrincipal) {
            uaaPrincipal = (UaaPrincipal)((Authentication)principal).getPrincipal();
            username = uaaPrincipal.getName();
            origin = uaaPrincipal.getOrigin();
            userId = uaaPrincipal.getId();
        } else {
            throw new UnknownPrincipalException();
        }
        PasscodeInformation pi = new PasscodeInformation(userId, username, null, origin, authorizationParameters);
        String intent = "PASSCODE " + pi.getUserId();
        this.expiringCodeStore.expireByIntent(intent);
        ExpiringCode code = this.expiringCodeStore.generateCode(JsonUtils.writeValueAsString((Object)pi), new Timestamp(System.currentTimeMillis() + this.getCodeExpirationMillis()), intent);
        model.put(PASSCODE, code.getCode());
        return PASSCODE;
    }

    protected Map<String, ?> getLinksInfo() {
        IdentityZone zone = IdentityZoneHolder.get();
        IdentityProvider uaaIdp = this.providerProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
        boolean disableInternalUserManagement = uaaIdp.getConfig() != null ? ((UaaIdentityProviderDefinition)uaaIdp.getConfig()).isDisableInternalUserManagement() : false;
        boolean selfServiceLinksEnabled = zone.getConfig() != null ? zone.getConfig().getLinks().getSelfService().isSelfServiceLinksEnabled() : true;
        String signup = zone.getConfig() != null ? zone.getConfig().getLinks().getSelfService().getSignup() : null;
        String passwd = zone.getConfig() != null ? zone.getConfig().getLinks().getSelfService().getPasswd() : null;
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("uaa", UaaUrlUtils.addSubdomainToUrl(this.getUaaBaseUrl()));
        if (this.getBaseUrl().contains("localhost:")) {
            model.put("login", UaaUrlUtils.addSubdomainToUrl(this.getUaaBaseUrl()));
        } else if (StringUtils.hasText((String)this.getExternalLoginUrl())) {
            model.put("login", this.getExternalLoginUrl());
        } else {
            model.put("login", UaaUrlUtils.addSubdomainToUrl(this.getUaaBaseUrl().replaceAll("uaa", "login")));
        }
        if (selfServiceLinksEnabled && !disableInternalUserManagement) {
            model.put(CREATE_ACCOUNT_LINK, "/create_account");
            model.put("register", "/create_account");
            model.put(FORGOT_PASSWORD_LINK, "/forgot_password");
            model.put("passwd", "/forgot_password");
            if (IdentityZoneHolder.isUaa()) {
                if (StringUtils.hasText((String)signup)) {
                    model.put(CREATE_ACCOUNT_LINK, signup);
                    model.put("register", signup);
                }
                if (StringUtils.hasText((String)passwd)) {
                    model.put(FORGOT_PASSWORD_LINK, passwd);
                    model.put("passwd", passwd);
                }
            }
        }
        return model;
    }

    public void setUaaBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        try {
            URI uri = new URI(baseUrl);
            this.setUaaHost(uri.getHost());
            if (uri.getPort() != 443 && uri.getPort() != 80 && uri.getPort() > 0) {
                this.setUaaHost(this.getUaaHost() + ":" + uri.getPort());
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not extract host from URI: " + baseUrl);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected String getUaaBaseUrl() {
        return this.baseUrl;
    }

    public String getUaaHost() {
        return this.uaaHost;
    }

    public void setUaaHost(String uaaHost) {
        this.uaaHost = uaaHost;
    }

    public void setExternalLoginUrl(String baseUrl) {
        this.externalLoginUrl = baseUrl;
    }

    public String getExternalLoginUrl() {
        return this.externalLoginUrl;
    }

    public String getSamlSPBaseUrl() {
        return this.samlSPBaseUrl;
    }

    public void setSamlSPBaseUrl(String samlSPBaseUrl) {
        this.samlSPBaseUrl = samlSPBaseUrl;
    }

    protected String extractPath(HttpServletRequest request) {
        String query = request.getQueryString();
        try {
            query = query == null ? "" : "?" + URLDecoder.decode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot decode query string: " + query);
        }
        String path = request.getRequestURI() + query;
        String context = request.getContextPath();
        path = path.substring(context.length());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public IdentityProviderProvisioning getProviderProvisioning() {
        return this.providerProvisioning;
    }

    public void setProviderProvisioning(IdentityProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN, reason="Unknown authentication token type, unable to derive user ID.")
    public static final class UnknownPrincipalException
    extends RuntimeException {
    }
}

