/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.jwt.IdentifiedSigner;
import org.cloudfoundry.identity.uaa.oauth.jwt.Signer;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.RsaSigner;

public class CommonSigner
implements Signer {
    private final Signer delegate;

    public CommonSigner(String keyId, String signingKey) {
        Object signer = KeyInfo.isAssymetricKey(signingKey) ? new RsaSigner(signingKey) : new MacSigner(signingKey);
        this.delegate = new IdentifiedSigner(keyId, (org.springframework.security.jwt.crypto.sign.Signer)signer);
    }

    @Override
    public String keyId() {
        return this.delegate.keyId();
    }

    public byte[] sign(byte[] bytes) {
        return this.delegate.sign(bytes);
    }

    public String algorithm() {
        return this.delegate.algorithm();
    }
}

