/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalGroupAuthorizationEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalLoginAuthenticationManager;
import org.cloudfoundry.identity.uaa.oauth.CommonSignatureVerifier;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.token.CompositeAccessToken;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.RawXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.XOIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthCodeToken;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthUserAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserPrototype;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.TokenValidation;
import org.cloudfoundry.identity.uaa.util.UaaHttpRequestUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class XOAuthAuthenticationManager
extends ExternalLoginAuthenticationManager {
    private RestTemplate restTemplate = new RestTemplate();
    private IdentityProviderProvisioning providerProvisioning;

    public XOAuthAuthenticationManager(IdentityProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    @Override
    protected UaaUser getUser(Authentication request) {
        XOAuthCodeToken codeToken = (XOAuthCodeToken)request;
        this.setOrigin(codeToken.getOrigin());
        IdentityProvider provider = this.providerProvisioning.retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId());
        if (provider != null && provider.getConfig() instanceof AbstractXOAuthIdentityProviderDefinition) {
            AbstractXOAuthIdentityProviderDefinition config = (AbstractXOAuthIdentityProviderDefinition)provider.getConfig();
            Map<String, Object> claims = this.getClaimsFromToken(codeToken, config);
            if (claims == null) {
                return null;
            }
            Map attributeMappings = config.getAttributeMappings();
            String email = (String)claims.get("email");
            String userNameAttributePrefix = (String)attributeMappings.get("user_name");
            String username = StringUtils.hasText((String)userNameAttributePrefix) ? (String)claims.get(userNameAttributePrefix) : (String)claims.get("preferred_username");
            if (email == null) {
                email = this.generateEmailIfNull(username);
            }
            return new UaaUser(new UaaUserPrototype().withEmail(email).withGivenName((String)claims.get("given_name")).withFamilyName((String)claims.get("family_name")).withPhoneNumber((String)claims.get("phone_number")).withModified(new Date()).withUsername(username).withPassword("").withAuthorities(this.extractXOAuthUserAuthorities(attributeMappings, claims)).withCreated(new Date()).withOrigin(this.getOrigin()).withExternalId(null).withVerified(true).withZoneId(IdentityZoneHolder.get().getId()).withSalt(null).withPasswordLastModified(null));
        }
        return null;
    }

    private List<? extends GrantedAuthority> extractXOAuthUserAuthorities(Map<String, Object> attributeMappings, Map<String, Object> claims) {
        LinkedList<String> groupNames = new LinkedList<String>();
        if (attributeMappings.get("external_groups") instanceof String) {
            groupNames.add((String)attributeMappings.get("external_groups"));
        } else if (attributeMappings.get("external_groups") instanceof Collection) {
            groupNames.addAll((Collection)attributeMappings.get("external_groups"));
        }
        HashSet<String> scopes = new HashSet<String>();
        for (String g : groupNames) {
            Object roles = claims.get(g);
            if (roles instanceof String) {
                scopes.addAll(Arrays.asList(((String)roles).split(",")));
                continue;
            }
            if (!(roles instanceof Collection)) continue;
            scopes.addAll((Collection)roles);
        }
        ArrayList<XOAuthUserAuthority> authorities = new ArrayList<XOAuthUserAuthority>();
        for (String scope : scopes) {
            authorities.add(new XOAuthUserAuthority(scope));
        }
        return authorities;
    }

    @Override
    protected UaaUser userAuthenticated(Authentication request, UaaUser userFromRequest, UaaUser userFromDb) {
        boolean userModified = false;
        if (request.getPrincipal() != null && this.haveUserAttributesChanged(userFromDb, userFromRequest)) {
            userFromDb = userFromDb.modifyAttributes(userFromRequest.getEmail(), userFromRequest.getGivenName(), userFromRequest.getFamilyName(), userFromRequest.getPhoneNumber()).modifyUsername(userFromRequest.getUsername());
            userModified = true;
        }
        ExternalGroupAuthorizationEvent event = new ExternalGroupAuthorizationEvent(userFromDb, userModified, userFromRequest.getAuthorities(), true);
        this.publish(event);
        return this.getUserDatabase().retrieveUserById(userFromDb.getId());
    }

    @Override
    protected boolean isAddNewShadowUser() {
        IdentityProvider provider = this.providerProvisioning.retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId());
        return ((AbstractXOAuthIdentityProviderDefinition)provider.getConfig()).isAddShadowUserOnLogin();
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    private String getResponseType(AbstractXOAuthIdentityProviderDefinition config) {
        if (RawXOAuthIdentityProviderDefinition.class.isAssignableFrom(config.getClass())) {
            return "token";
        }
        if (XOIDCIdentityProviderDefinition.class.isAssignableFrom(config.getClass())) {
            return "id_token";
        }
        throw new IllegalArgumentException("Unknown type for provider.");
    }

    private Map<String, Object> getClaimsFromToken(XOAuthCodeToken codeToken, AbstractXOAuthIdentityProviderDefinition config) {
        String idToken = this.getTokenFromCode(codeToken, config);
        if (idToken == null) {
            return null;
        }
        String tokenKey = config.getTokenKey();
        URL tokenKeyUrl = config.getTokenKeyUrl();
        if (!StringUtils.hasText((String)tokenKey) && tokenKeyUrl != null && StringUtils.hasText((String)tokenKeyUrl.toString())) {
            tokenKey = this.getTokenKeyFromOAuth(config, tokenKeyUrl.toString());
        }
        TokenValidation validation = TokenValidation.validate(idToken).checkSignature(new CommonSignatureVerifier(tokenKey)).checkIssuer(config.getTokenUrl().toString()).checkAudience(config.getRelyingPartyId()).checkExpiry().throwIfInvalid();
        Jwt decodeIdToken = validation.getJwt();
        return (Map)JsonUtils.readValue((String)decodeIdToken.getClaims(), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    private String getTokenKeyFromOAuth(AbstractXOAuthIdentityProviderDefinition config, String tokenKeyUrl) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Authorization", (Object)this.getClientAuthHeader(config));
        headers.add((Object)"Accept", (Object)"application/json");
        HttpEntity tokenKeyRequest = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(tokenKeyUrl, HttpMethod.GET, tokenKeyRequest, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        return (String)((Map)responseEntity.getBody()).get("value");
    }

    private String getTokenFromCode(XOAuthCodeToken codeToken, AbstractXOAuthIdentityProviderDefinition config) {
        URI requestUri;
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"authorization_code");
        body.add((Object)"response_type", (Object)this.getResponseType(config));
        body.add((Object)"code", (Object)codeToken.getCode());
        body.add((Object)"redirect_uri", (Object)codeToken.getRedirectUrl());
        HttpHeaders headers = new HttpHeaders();
        String clientAuthHeader = this.getClientAuthHeader(config);
        headers.add("Authorization", clientAuthHeader);
        headers.add("Accept", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            requestUri = config.getTokenUrl().toURI();
        }
        catch (URISyntaxException e) {
            return null;
        }
        if (config.isSkipSslValidation()) {
            this.restTemplate.setRequestFactory(UaaHttpRequestUtils.getNoValidatingClientHttpRequestFactory());
        }
        ResponseEntity responseEntity = this.restTemplate.exchange(requestUri, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, String>>(){});
        return (String)((Map)responseEntity.getBody()).get(CompositeAccessToken.ID_TOKEN);
    }

    private String getClientAuthHeader(AbstractXOAuthIdentityProviderDefinition config) {
        String clientAuth = new String(Base64.encodeBase64((byte[])(config.getRelyingPartyId() + ":" + config.getRelyingPartySecret()).getBytes()));
        return "Basic " + clientAuth;
    }
}

