/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.cloudfoundry.identity.uaa.security.X509ExpiryCheckingTrustManager;

public class LdapSocketFactory
extends SSLSocketFactory {
    private static SocketFactory instance;
    private SSLSocketFactory delegate;

    public static SocketFactory getDefault() {
        if (instance == null) {
            instance = new LdapSocketFactory();
        }
        return instance;
    }

    public LdapSocketFactory() {
        try {
            X509ExpiryCheckingTrustManager trustManager = new X509ExpiryCheckingTrustManager();
            TrustManager[] tma = new TrustManager[]{trustManager};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, tma, new SecureRandom());
            this.delegate = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
        return this.delegate.createSocket(socket, s, i, b);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.delegate.createSocket(s, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException {
        return this.delegate.createSocket(s, i, inetAddress, i1);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.delegate.createSocket(inetAddress, i);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this.delegate.createSocket(inetAddress, i, inetAddress1, i1);
    }
}

