/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import org.cloudfoundry.identity.uaa.zone.GeneralIdentityZoneConfigurationValidator;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfigurationValidator;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneValidator;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneConfigurationException;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneDetailsException;

public class GeneralIdentityZoneValidator
implements IdentityZoneValidator {
    private final IdentityZoneConfigurationValidator configValidator;

    public GeneralIdentityZoneValidator() {
        this(new GeneralIdentityZoneConfigurationValidator());
    }

    public GeneralIdentityZoneValidator(IdentityZoneConfigurationValidator configValidator) {
        this.configValidator = configValidator;
    }

    @Override
    public IdentityZone validate(IdentityZone identityZone, IdentityZoneValidator.Mode mode) throws InvalidIdentityZoneDetailsException {
        try {
            IdentityZoneConfigurationValidator.Mode configValidateMode = null;
            if (mode == IdentityZoneValidator.Mode.CREATE) {
                configValidateMode = IdentityZoneConfigurationValidator.Mode.CREATE;
            } else if (mode == IdentityZoneValidator.Mode.MODIFY) {
                configValidateMode = IdentityZoneConfigurationValidator.Mode.MODIFY;
            } else if (mode == IdentityZoneValidator.Mode.DELETE) {
                configValidateMode = IdentityZoneConfigurationValidator.Mode.DELETE;
            }
            identityZone.setConfig(this.configValidator.validate(identityZone.getConfig(), configValidateMode));
        }
        catch (InvalidIdentityZoneConfigurationException ex) {
            throw new InvalidIdentityZoneDetailsException("The zone configuration is invalid.", ex);
        }
        return identityZone;
    }
}

