/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit;

import java.sql.Timestamp;
import javax.sql.DataSource;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.JdbcAuditService;

public class JdbcFailedLoginCountingAuditService
extends JdbcAuditService {
    private int saveDataPeriodMillis = 0x6DDD00;

    public JdbcFailedLoginCountingAuditService(DataSource dataSource) {
        super(dataSource);
    }

    public void setSaveDataPeriodMillis(int saveDataPeriodMillis) {
        this.saveDataPeriodMillis = saveDataPeriodMillis;
    }

    @Override
    public void log(AuditEvent auditEvent) {
        switch (auditEvent.getType()) {
            case UserAuthenticationSuccess: 
            case PasswordChangeSuccess: {
                this.getJdbcTemplate().update("delete from sec_audit where principal_id=?", new Object[]{auditEvent.getPrincipalId()});
                break;
            }
            case UserAuthenticationFailure: {
                this.getJdbcTemplate().update("delete from sec_audit where created < ?", new Object[]{new Timestamp(System.currentTimeMillis() - (long)this.saveDataPeriodMillis)});
                super.log(auditEvent);
                break;
            }
        }
    }
}

