/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import org.cloudfoundry.identity.uaa.client.ClientDetailsValidator;
import org.cloudfoundry.identity.uaa.client.InvalidClientDetailsException;
import org.cloudfoundry.identity.uaa.client.UaaScopes;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.ClientDetails;

public class RestrictUaaScopesClientValidator
implements ClientDetailsValidator {
    private final UaaScopes uaaScopes;

    public RestrictUaaScopesClientValidator(UaaScopes uaaScopes) {
        this.uaaScopes = uaaScopes;
    }

    public UaaScopes getUaaScopes() {
        return this.uaaScopes;
    }

    @Override
    public ClientDetails validate(ClientDetails clientDetails, ClientDetailsValidator.Mode mode) throws InvalidClientDetailsException {
        if (ClientDetailsValidator.Mode.CREATE.equals((Object)mode) || ClientDetailsValidator.Mode.MODIFY.equals((Object)mode)) {
            for (String scope : clientDetails.getScope()) {
                if (!this.uaaScopes.isUaaScope(scope)) continue;
                throw new InvalidClientDetailsException(scope + " is a restricted scope.");
            }
            for (GrantedAuthority authority : clientDetails.getAuthorities()) {
                if (!this.uaaScopes.isUaaScope(authority)) continue;
                throw new InvalidClientDetailsException(authority.getAuthority() + " is a restricted authority.");
            }
        }
        return clientDetails;
    }
}

