/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

public class CommonSignatureVerifier
implements SignatureVerifier {
    private final SignatureVerifier delegate;

    public CommonSignatureVerifier(String verificationKey) {
        this.delegate = verificationKey == null ? new SignatureVerifier(){

            public void verify(byte[] content, byte[] signature) {
            }

            public String algorithm() {
                return "none";
            }
        } : (KeyInfo.isAssymetricKey(verificationKey) ? new RsaVerifier(verificationKey) : new MacSigner(verificationKey));
    }

    public void verify(byte[] content, byte[] signature) {
        this.delegate.verify(content, signature);
    }

    public String algorithm() {
        return this.delegate.algorithm();
    }
}

